/*
 * @(#)TraversalCitiesList 22 March 2006
 *
 * @author Viera K. Proulx
 */
import java.util.NoSuchElementException;

/* ------------------------------------------------------------------
 A non-mutable iterator for a list of cities based on ArrayList 
 */
public class TraversalCitiesList implements Traversal<City>{
  CitiesAList cities;
  
  /*-------------------------------------------------------- 
   Constructor
   *------------------------------------------------------*/    
  public TraversalCitiesList(CitiesAList cities){
    this.cities = cities;
  }
  
  /*--------------------------------------------------------
   Methods to implement the Traversal interface
   *------------------------------------------------------*/

  /* move the cursor one forward, if not at the end */
  public Traversal<City> advance(){
    if (this.cities instanceof CitiesConsList)
      return 
        new TraversalCitiesList(((CitiesConsList)cities).rest);
    else
      throw new NoSuchElementException(
      "Cannot advance beyond the last element in ArrayList");
  }
  
  /* select the item to which the cursor points */
  public City current(){
    if (this.cities instanceof CitiesConsList)
      return ((CitiesConsList)cities).first;
    else
      throw new NoSuchElementException(
      "No current element after the last element in ArrayList");
  }
  
  /* test whether there are more items to traverse */
  public boolean hasMore(){
    return this.cities instanceof CitiesConsList;
  }
  
  /*--------------------------------------------------------
  Self Test
  *------------------------------------------------------*/
  public static void main(String argv[]){
    City northville = 
      new City(48167, "Northville", "MI", 83.479355, 42.426245);
    City pinckney = 
      new City("48169", "Pinckney", "MI", 83.909918, 42.459579);
    City plymouth = 
      new City(48170, "Plymouth", "MI", 83.479946, 42.36882);
    City plymouth2 = new City();
    
    CitiesAList empty = new CitiesMTList();
    CitiesAList alist = new CitiesConsList(northville,
        new CitiesConsList(pinckney,
            new CitiesConsList(plymouth,
                new CitiesConsList(plymouth2, empty))));
                    
    
    
    System.out.println("Examples of CitiesList-s:");
    Traversal tr = new TraversalCitiesList(alist);
    
    while (tr.hasMore()){
      System.out.println(tr.current().toString());
      tr = tr.advance(); 
    }
    System.out.println("End of the list.");
  }
}

