/* TestSuite.java  16 April 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.awt.*;
import java.math.*;
import java.util.*;

public class TestSuite extends JPFalt {
    public static void main(String[] args) { new TestSuite(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
    /*----------------------------------------------------------------------- 
     * Test city constructors
     *----------------------------------------------------------------------- */
    void TestCity(){
	
        City nyc = new City();
        println(nyc);
        
        City boston = new City(02115, "Boston", "MA", 71.092215, 42.342706);
        println(boston);
        
        City bos = new City(boston);
        println(boston);
        
        println("Testing zip code converter");
        expected(12345);
        actual(boston.decimal("12345"));
        
        expected(2145);
        actual(boston.decimal("02145"));
    }
    
    /*----------------------------------------------------------------------- 
     * Test GUI iterator for input of list of cities
     *----------------------------------------------------------------------- */
    void TestInGuiRange(){
        AList cities = new EmptyList();
        
        for (IRange it = new InGuiRange();
             it.hasMore();
             it.next()){
            cities = new ConsList((City)it.current(), cities);
            println("Next in City: " + ((ConsList)cities).first);
        }
        
        println("Done with gui input iterator.");
    }

    /*----------------------------------------------------------------------- 
     * Test buffered file channel and iterator for input of list of cities
     *----------------------------------------------------------------------- */
    void TestInFileRangeBuffered(){
        int count = 0;
        
        for (IRange it = new InFileRangeBuffered();
             it.hasMore();
             it.next()){
	    City current = (City)it.current();
	    if (count < 50)
		println("Next in City: " + current);
	    else if (count == 50) 
		println("Not displaying the rest of the cities.");
            
	    count++;
            
        }
        println("Read " + count + " cities from file input iterator.");
    }

    /*-----------------------------------------------------------------------
     * Test console channel and iterator for input of list of balloons
     *----------------------------------------------------------------------- */
    void TestInConsoleRange(){
    
        City[] cities = new City[20];
        int i = 0;
        
        for (InConsoleRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            println("loop");
            cities[i] = (City)it.current();
            
            println(cities[i]);
            i++;
        }
    }

    /*-----------------------------------------------------------------------
     * Test AAlgorithms on Integers
     *----------------------------------------------------------------------- */
    abstract class AlgorithmsWrapper {
	abstract AAlgorithms init(IRange input);
	abstract void execute(AAlgorithms aa, Comparator c);
	abstract IRange iterator(AAlgorithms aa);
    }
    abstract class ArrayWrapper extends AlgorithmsWrapper {
	AAlgorithms init(IRange input) {
	    return new ArrayListAlgorithms(input);
	}
	abstract void execute(AAlgorithms aa, Comparator c);
	IRange iterator(AAlgorithms aa) {
	    return new IteratorRange
		(((ArrayListAlgorithms)aa).dataset.iterator());
	}
    }
    abstract class ListWrapper extends AlgorithmsWrapper {
	AAlgorithms init(IRange input) {
	    return new ListAlgorithms(input);
	}
	abstract void execute(AAlgorithms aa, Comparator c);
	IRange iterator(AAlgorithms aa) {
	    return new ListRange(((ListAlgorithms)aa).dataset);
	}
    }

    void runIntegerTest(AlgorithmsWrapper wrapper, String description) {
	AList sample = 
	    new ConsList(new Integer(3),
			 new ConsList(new Integer(1),
				      new ConsList(new Integer(2),
						   new EmptyList())));
	Comparator c = new Comparator() {
		public int compare(Object a, Object b) {
		    return ((Integer)a).intValue() -
			((Integer)b).intValue();
		}
	    };
	
	AAlgorithms aa = wrapper.init(new ListRange(sample));
	wrapper.execute(aa, c);
	
	int i = 1;
	for (IRange iterator = wrapper.iterator(aa); 
	     iterator.hasMore();
	     iterator.next(), i++) {
	    Integer expected = new Integer(i);
	    if (!expected.equals(iterator.current())) {
		println("FAILED: " + description);
		return;
	    }
	}
	println("Success: " + description);
    }
    void IntegerInsertionSort() {
	runIntegerTest(new ArrayWrapper() {
		void execute(AAlgorithms aa, Comparator c) {
		    aa.insertionSort(c);
		}
	    },
		       "insertion sort on ArrayList");
	runIntegerTest(new ListWrapper() {
		void execute(AAlgorithms aa, Comparator c) {
		    aa.insertionSort(c);
		}
	    },
		       "insertion sort on AList");
    }
    void IntegerMergeSort() {
	runIntegerTest(new ArrayWrapper() {
		void execute(AAlgorithms aa, Comparator c) {
		    aa.mergeSort(c);
		}
	    },
		       "merge sort on ArrayList");
	runIntegerTest(new ListWrapper() {
		void execute(AAlgorithms aa, Comparator c) {
		    aa.mergeSort(c);
		}
	    },
		       "merge sort on AList");
    }
	
    /*-----------------------------------------------------------------------
     * Test AAlgorithms on Cities
     *----------------------------------------------------------------------- */
    void runCityTest(AlgorithmsWrapper wrapper, Comparator c, 
		     String description) {
	InFileRangeBuffered ifrb = new InFileRangeBuffered();
	AAlgorithms aa = wrapper.init(ifrb);
	
	long startTime = System.currentTimeMillis();
	wrapper.execute(aa, c);
	long endTime = System.currentTimeMillis();
	
	println("Algorithm finished in " + 
		(endTime-startTime) + 
		" milliseconds");
	
	Object last = null;
	for (IRange ai = wrapper.iterator(aa); ai.hasMore(); ai.next()) {
	    if (last != null) {
		if (c.compare(last, ai.current()) > 0) {
		    println("FAILED: " + description);
		    return;
		}
	    }
	    last = ai.current();
	}
	println("Success: " + description);
    }

    void CityInsertArrayZIP() {
	runCityTest(new ArrayWrapper() {
		void execute(AAlgorithms aa, Comparator c) {
		    aa.insertionSort(c);
		}
	    },
		    new ZipComparator(),
		    "insertion sort on ArrayList using Zip comparator");
    }
    void CityInsertAListZIP() {
	runCityTest(new ListWrapper() {
		void execute(AAlgorithms aa, Comparator c) {
		    aa.insertionSort(c);
		}
	    },
		    new ZipComparator(),
		    "insertion sort on AList using Zip comparator");
    }
    void CityMergeArrayZIP() {
	runCityTest(new ArrayWrapper() {
		void execute(AAlgorithms aa, Comparator c) {
		    aa.mergeSort(c);
		}
	    },
		    new ZipComparator(),
		    "merge sort on ArrayList using Zip comparator");
    }
    void CityMergeAListZIP() {
	runCityTest(new ListWrapper() {
		void execute(AAlgorithms aa, Comparator c) {
		    aa.mergeSort(c);
		}
	    },
		    new ZipComparator(),
		    "merge sort on AList using Zip comparator");
    }

    /*-----------------------------------------------------------------------
     * Utility methods
     *----------------------------------------------------------------------- */

    /** convert a String to int - if possible */
    protected int intValue(String s){
        int n = 0;
        try{
            n = (new XInt(s)).intValue();
        }
        catch(java.text.ParseException e){
            println("Cannot convert " + s + " to integer.");
        }
        return n;
    }
}

