import java.util.Iterator;

class IteratorRange implements IRange {
    Iterator iterator;
    Object current;
    boolean currentValid;
    public IteratorRange(Iterator iterator) {
	this.iterator = iterator;
	this.current = null;
	this.currentValid = false;
    }
    public boolean hasMore() {
	return currentValid || iterator.hasNext();
    }
    public Object current() {
	if (currentValid) return current;
	current = iterator.next();
	currentValid = true;
	return current;
    }
    public void next() {
	current = null;
	currentValid = false;
    }
}

