#include "MinSpan.h"

configuration MinSpan {
}
implementation {
    components Main, MinSpanM, TimerC, LedsC, RandomLFSR;
    components GenericComm, HamamatsuC;
    components CC2420RadioC;

    Main.StdControl -> MinSpanM.StdControl;
    Main.StdControl -> TimerC.StdControl;
    Main.StdControl -> HamamatsuC.StdControl;

    MinSpanM.Timer -> TimerC.Timer[unique("Timer")];
    MinSpanM.SendHopMsg -> GenericComm.SendMsg[AM_HOPMSG];
    MinSpanM.ReceiveHopMsg -> GenericComm.ReceiveMsg[AM_HOPMSG];
    MinSpanM.SendAlarmMsg -> GenericComm.SendMsg[AM_ALARMMSG];
    MinSpanM.ReceiveAlarmMsg -> GenericComm.ReceiveMsg[AM_ALARMMSG];
    
    MinSpanM.Leds -> LedsC;
    MinSpanM.Random -> RandomLFSR;
    MinSpanM.CC2420Control -> CC2420RadioC.CC2420Control;
    MinSpanM.ADC -> HamamatsuC.TSR;
}

