#include "../CountMsg.h"

module NodeM{

	provides{
	interface StdControl;
	}

	uses{
	interface Leds;
	interface ADC as TSR;
	interface Timer2<TMilli> as HopTimer;
	interface Timer2<TMilli> as TsrTimer;
	interface Timer2<TMilli> as TimeOut;
	interface SendMsg;
	interface CC2420Control;
	interface ReceiveMsg;
	}

}

implementation{

 norace TOS_Msg m_msg;
 norace uint16_t parentId;
 norace uint16_t nodeId;
 norace uint8_t hcount;
 norace uint16_t tsr;
 

  command result_t StdControl.init() {
	nodeId = TOS_LOCAL_ADDRESS;
	hcount = 0;
	return SUCCESS;
  }

  command result_t StdControl.start() {
	call HopTimer.startPeriodic( TIMER_PERIOD );
	call TsrTimer.startPeriodic( TSR_PERIOD );
	call CC2420Control.SetRFPower(RESOURCE_NONE, RADIO_POWER); 
	return SUCCESS;
  }

  command result_t StdControl.stop() {
	call HopTimer.stop();
	call TsrTimer.stop();
	return SUCCESS;
  }

  event void HopTimer.fired() {
	if(hcount == 0)
	{
		call Leds.set(0);
	}
	else{
		CountMsg_t* body = (CountMsg_t*)m_msg.data;
		body -> src = nodeId;
		body -> hopcount = hcount;
		body -> packetType = HOP_PKT;
		call SendMsg.send( TOS_BCAST_ADDR, sizeof(CountMsg_t), &m_msg);
	}

}
  


  event void TimeOut.fired(){
		hcount = 0;
   		parentId = 0;
		call Leds.set(0);
  }


  event void TsrTimer.fired(){
	call TSR.getData();
  }

async event result_t TSR.dataReady(uint16_t data) {
	tsr = data;
	if(tsr < 10)
	{
	CountMsg_t* body = (CountMsg_t*)m_msg.data;
	body -> src = nodeId;
	body -> dest = parentId;
	body -> packetType = TSR_PKT;	
	call Leds.set(7);
	call SendMsg.send( TOS_BCAST_ADDR, sizeof(CountMsg_t), &m_msg);
	}
	tsr = 10;
	return SUCCESS;
}

   
  event result_t SendMsg.sendDone( TOS_MsgPtr msg, result_t success ) {	
	return SUCCESS;

  }

  event TOS_MsgPtr ReceiveMsg.receive( TOS_MsgPtr msg ) {
	
	uint8_t ptype;
	uint8_t temp;

	CountMsg_t* body = (CountMsg_t*)msg->data;
	ptype = body -> packetType;
	
	if(ptype == HOP_PKT)
	{
		temp = (body -> hopcount) + 1;
		if(body->src == parentId && temp == hcount)
		{
			call TimeOut.stop();
			call TimeOut.startOneShot(TIME_OUT_PERIOD);
		}
		if(temp < hcount)
		{
			call TimeOut.stop();
			hcount = temp;
			parentId = body->src;
			call TimeOut.startOneShot(TIME_OUT_PERIOD);
		}
				
	}
	
	if((ptype == TSR_PKT) && (body -> dest == nodeId))
	{
		CountMsg_t* b = (CountMsg_t*)m_msg.data;
		b -> src = nodeId;
		b -> dest = parentId;
		b -> packetType = TSR_PKT;
		call Leds.set(7);
	 	call SendMsg.send( TOS_BCAST_ADDR, sizeof(CountMsg_t), &m_msg);
	
	}
	return msg;

  }




}



