includes IntMsg;

module RfmToIntM {
  provides interface StdControl;
  uses {
    interface ReceiveMsg as ReceiveIntMsg;
    interface Output;
    interface StdControl as CommControl;
    interface Timer;
  }
}
implementation {


	uint16_t lastSeq;
	uint16_t requester;
	uint16_t received[32];
	int counter;
	int i;
  command result_t StdControl.init() {
  	
  	lastSeq=0;
  	counter=0;
	
	for(i=0;i<32;i++){
		received[i]=0;
	}
    return call CommControl.init();
  }

  command result_t StdControl.start() {
  	if(TOS_LOCAL_ADDRESS==0)
   		  call Timer.start(TIMER_ONE_SHOT, 10000);//TIMER_REPEAT or TIMER_ONE_SHOT
    return call CommControl.start();
  }

  command result_t StdControl.stop() {
  	if(TOS_LOCAL_ADDRESS==0)
	  	call Timer.stop();
    return call CommControl.stop();
  }

  event TOS_MsgPtr ReceiveIntMsg.receive(TOS_MsgPtr m) {
  		
    IntMsg *message = (IntMsg *)m->data;
    uint16_t currentSeq=message->val;
	
    if(lastSeq<currentSeq&&(currentSeq-lastSeq)%2==0) //get a new broadcast
    {
	  call Output.removeAll();
	 
	  //dbg(DBG_TEMP, "Received %i\n", (int)message->src);
  	  lastSeq=currentSeq;
  	  counter=0;
  	  requester=message->src;
	  call Output.output(currentSeq, TOS_BCAST_ADDR,TRUE, counter);
  	  call Output.output(currentSeq+1+2*TOS_LOCAL_ADDRESS, requester,FALSE, counter);
	  
    }
    else {
    	if(lastSeq<currentSeq&&(currentSeq-lastSeq)%2==1)//get a response
    	{
			if(message->src==requester){
				call Output.removeCmd(currentSeq);  //get an ack
			}
			else{
				
				call Output.output(currentSeq, message->src,TRUE, counter);//Ack				
				if(received[(currentSeq-lastSeq-1)/2]==0)
				{
					counter++;
					received[(currentSeq-lastSeq-1)/2]=1;
					dbg(DBG_TEMP, "Response from %i, relay for %i\n", (int)message->src,(currentSeq-lastSeq-1)/2);
					dbg(DBG_TEMP, "Counter: Value is %i\n", (int)counter);
					call Output.output(currentSeq, requester,FALSE, counter);				
				}
			}
		}
	}
	
    return m;
  }

  event result_t Output.outputComplete(result_t success) {
    return SUCCESS;
  }
  
   event result_t Timer.fired()
  {
    lastSeq+=2;
	counter=0;
	for(i=0;i<32;i++){
		received[i]=0;
	}
	call Output.removeAll();
	dbg(DBG_TEMP, "A new session started. The sequence # is %i\n",lastSeq);
	
    return call Output.output(lastSeq,TOS_BCAST_ADDR,TRUE, counter);
  }
}
