includes IntMsg;

module RfmToIntM {
  provides interface StdControl;
  uses {
    interface ReceiveMsg as ReceiveIntMsg;
    interface Output;
    interface StdControl as CommControl;
    interface Timer;
  }
}
implementation {


	uint16_t lastSeq;
	uint16_t requester;
	int counter;
  command result_t StdControl.init() {
  	
  	lastSeq=0;
  	counter=0;
    return call CommControl.init();
  }

  command result_t StdControl.start() {
  	if(TOS_LOCAL_ADDRESS==0)
   		  call Timer.start(TIMER_REPEAT, 10000);
    return call CommControl.start();
  }

  command result_t StdControl.stop() {
  	if(TOS_LOCAL_ADDRESS==0)
	  	call Timer.stop();
    return call CommControl.stop();
  }

  event TOS_MsgPtr ReceiveIntMsg.receive(TOS_MsgPtr m) {
  		
    IntMsg *message = (IntMsg *)m->data;
    uint16_t currentSeq=message->val;
	
    if(lastSeq<currentSeq&&(currentSeq-lastSeq)%2==0)
    {
	//  dbg(DBG_TEMP, "Received %i\n", (int)message->src);
  	  lastSeq=currentSeq;
  	  counter=0;
  	  requester=message->src;
  	  call Output.output(currentSeq+1, requester, counter);
	  call Output.output(currentSeq, TOS_BCAST_ADDR, counter);
    }
    else {
    	if(currentSeq==(lastSeq+1))
    	{
    		counter++;
			dbg(DBG_TEMP, "Response from %i\n", (int)message->src);
    		dbg(DBG_TEMP, "Counter: Value is %i\n", (int)counter);
    		call Output.output(currentSeq, requester, counter);				
		}
	}
	
    return m;
  }

  event result_t Output.outputComplete(result_t success) {
    return SUCCESS;
  }
  
   event result_t Timer.fired()
  {
    lastSeq+=2;
	counter=0;
	dbg(DBG_TEMP, "A new session started.\n");
    return call Output.output(lastSeq,TOS_BCAST_ADDR,counter);
  }
}
