

includes IntMsg;

module IntToRfmM 
{
  uses {
    interface StdControl as SubControl;
    interface SendMsg as Send;
	interface Timer as ResendTimer;
  }
  provides {
    interface Output;
    interface StdControl;
  }
}
implementation
{
  bool pending;
  
  struct TOS_Msg data;
  uint16_t buffer[10][2];
  int start,end;
  command result_t StdControl.init() {
    pending = FALSE;
	start=0;
	end=0;
 
    return call SubControl.init();
  }

  command result_t StdControl.start() 
  {
   
   	call ResendTimer.start(TIMER_REPEAT, TOS_LOCAL_ADDRESS*5+10);  
    return call SubControl.start();
  }


    command result_t StdControl.stop() 
  {
    call ResendTimer.stop();
    return call SubControl.stop();
  }

  command result_t Output.output(uint16_t seq, uint16_t dest,int counter)
  {
   		  if(TOS_LOCAL_ADDRESS==dest)
		  		return SUCCESS;					 
   		  if(((end+1)%10)==start)
		  		return FAIL;
		  
		  atomic {
		    buffer[end][0]=seq;
		    buffer[end][1]=dest;
		    end=(end+1)%10;
		  }
		  return SUCCESS;
   
  }

  event result_t Send.sendDone(TOS_MsgPtr msg, result_t success)
  {
    if (pending && msg == &data)
    {
	   		atomic {
				//if(msg->ack==1||buffer[start][1]==TOS_BCAST_ADDR)
	   			   	start=(start+1)%10;
			}
			pending = FALSE;
			signal Output.outputComplete(success);
    }
    return SUCCESS;
  }
   event result_t ResendTimer.fired()
  {
   		
   	 if(start!=end){
   	      IntMsg *message = (IntMsg *)data.data;
          if (!pending) 
  	      {
			pending = TRUE;
			
			message->val = buffer[start][0];
			atomic {
	  			   message->src = TOS_LOCAL_ADDRESS;
			}
			
			if (call Send.send(buffer[start][1], sizeof(IntMsg), &data))
	  		   return SUCCESS;
			
			pending = FALSE;
           }
	  }
      return FAIL;
  }
}




