/*
 * Counting the number of nodes reachable from the base
 * @author Richard Jia
 */

includes TopoCtrlMsg;

configuration CountingNode { }

implementation {
  components Main, CountingNodeM, TimerC, LedsC, GenericComm as Comm, RandomLFSR;

  Main.StdControl -> CountingNodeM.StdControl;
  Main.StdControl -> TimerC.StdControl;

  CountingNodeM.BaseStationEpochTimer -> TimerC.Timer[unique("Timer")];
  CountingNodeM.ForwardTimer -> TimerC.Timer[unique("Timer")];
  CountingNodeM.ForwardReplyTimer -> TimerC.Timer[unique("Timer")];
  CountingNodeM.ReplyTimer -> TimerC.Timer[unique("Timer")];
  CountingNodeM.RetransTimer -> TimerC.Timer[unique("Timer")];
  CountingNodeM.Leds -> LedsC.Leds;
  CountingNodeM.CommControl -> Comm;
  CountingNodeM.SendMsg -> Comm.SendMsg[TOPO_CTRL_MSG];
  CountingNodeM.ReceiveMsg -> Comm.ReceiveMsg[TOPO_CTRL_MSG];
  CountingNodeM.Random -> RandomLFSR.Random;

}
