 /**
 * DaIntToLedsM.nc
 * @author Daria Antonova
 * (adapted from IntToLedsM TinyOS module
 */

module DaIntToLedsM {
  uses interface Leds;

  provides interface IntOutput;
  provides interface StdControl;
}
implementation
{
  command result_t StdControl.init()
  {
    call Leds.init();
    call Leds.redOff();
    call Leds.yellowOff();
    call Leds.greenOff();
    return SUCCESS;
  }

  command result_t StdControl.start() {
    return SUCCESS;
  }

  command result_t StdControl.stop() {
    return SUCCESS;
  }


  task void outputDone()
  {
    signal IntOutput.outputComplete(1);
  }

  command result_t IntOutput.output(uint16_t value)
  {
    if (value & 1) call Leds.yellowOn();
    else call Leds.yellowOff();
    if (value & 2) call Leds.greenOn();
    else call Leds.greenOff();
    if (value & 4) call Leds.redOn();
    else call Leds.redOff();

    post outputDone();

    dbg(DBG_TEMP, "DaIntToLeds: display %i\n", (int)value);

    return SUCCESS;
  }
}
