#include "AlarmMsg.h"

module radioDemoM {
  provides {
    interface StdControl;
  }
  uses {
    interface Timer;
    interface Leds;
    interface ADC;
    interface SendMsg;
    interface ReceiveMsg;
  }
}

implementation {

  TOS_Msg m_msg;
  bool m_sending;

  command result_t StdControl.init() {
    return SUCCESS;    
  }
  command result_t StdControl.start() {
    return call Timer.start(TIMER_REPEAT, 1000);
  }
  command result_t StdControl.stop() {
    return call Timer.stop();    
  }
  
  event result_t Timer.fired() {
    return call ADC.getData();
  }

  async event result_t ADC.dataReady(uint16_t data) {
    if(data < 45) {
      call Leds.greenOff();
      call Leds.yellowOn();
    }
    else {
      call Leds.greenOn();
      call Leds.yellowOff();
    }

      atomic{
      if(m_sending == FALSE) {
        AlarmMsg_t* body = (AlarmMsg_t*)m_msg.data;
        body->data = data;
        body->src = TOS_LOCAL_ADDRESS;
        if( call SendMsg.send( TOS_BCAST_ADDR, sizeof(AlarmMsg_t), &m_msg ) == SUCCESS ) 
          m_sending = TRUE;
      }
      }
    return SUCCESS;
  }

  event result_t SendMsg.sendDone( TOS_MsgPtr msg, result_t success ) {
    atomic {
    m_sending = FALSE;
    }
    return SUCCESS;
  }

  event TOS_MsgPtr ReceiveMsg.receive( TOS_MsgPtr msg ) {
    AlarmMsg_t* body = (AlarmMsg_t*)msg->data;
    if(body->data < 45){
      call Leds.redOn();
    }
    else {
      call Leds.redOff();
    }
    return msg;
  }
  
}
