#|
This data is designed to work only with the two neural net learning
algorithms, perceptron and backprop.  The training data is essentially 
identical to that in "play-tennis-data.lisp" but here the networks are
forced to use an input encoding that uses only a single unit for the
3 values of Forecast and a single unit for the 3 values of Temperature.
|#

(defvar *input-ranges*)
(defvar *output-ranges*)
(defvar *data*)

(setf *input-ranges*
      '((0 1)                    ; Outlook (sunny=0, overcast=0.5, rain=1)
	(0 1)                    ; Temperature (cool=0, mild=0.5, hot=1)
	(normal high)            ; Humidity
	(weak strong)))          ; Wind

(setf *output-ranges*
      '((no yes)))               ; PlayTennis

(setf *data*
      '(((0 1 high weak) (no))
	((0 1 high strong) (no))
	((0.5 1 high weak) (yes))
	((1 0.5 high weak) (yes))
	((1 0 normal weak) (yes))
	((1 0 normal strong) (no))
	((0.5 0 normal strong) (yes))
	((0 0.5 high weak) (no))
	((0 0 normal weak) (yes))
	((1 0.5 normal weak) (yes))
	((0 0.5 normal strong) (yes))
	((0.5 0.5 high strong) (yes))
	((0.5 1 normal weak) (yes))
	((1 0.5 high strong) (no))))

(define-training-data *input-ranges* *output-ranges* *data*)
