#|
Digits represented in terms of 7-segment display.
The segments are laid out like this:

  *-2-*
  :   :
  1   3
  :   :
  *-0-*
  :   :
  6   4
  :   :
  *-5-*

|#

(setf *zero*  '(0 1 1 1 1 1 1))
(setf *one*   '(0 0 0 1 1 0 0))
(setf *two*   '(1 0 1 1 0 1 1))
(setf *three* '(1 0 1 1 1 1 0))
(setf *four*  '(1 1 0 1 1 0 0))
(setf *five*  '(1 1 1 0 1 1 0))
(setf *six*   '(1 1 1 0 1 1 1))
(setf *seven* '(0 0 1 1 1 0 0))
(setf *eight* '(1 1 1 1 1 1 1))
(setf *nine*  '(1 1 1 1 1 1 0))

(setf *input-ranges*
      '((0 1) (0 1) (0 1) (0 1) (0 1) (0 1) (0 1)))

(setf *digit-output-ranges*
      '((zero one two three four five six seven eight nine)))

;;; All of these are linearly separable

(setf *digit-data*
      `((,*zero*  (zero))
	(,*nine*  (nine))
	(,*eight* (eight))
	(,*seven* (seven))
	(,*six*   (six))
	(,*five*  (five))
	(,*four*  (four))
	(,*three* (three))
	(,*two*   (two))
	(,*one*   (one))
	))

(setf *odd-even-data*
      `((,*zero*  (even))
	(,*nine*  (odd))
	(,*eight* (even))
	(,*seven* (odd))
	(,*six*   (even))
	(,*five*  (odd))
	(,*four*  (even))
	(,*three* (odd))
	(,*two*   (even))
	(,*one*   (odd))
	))

(setf *less-than-five-data*
      `((,*zero*  (less))
	(,*nine*  (not-less))
	(,*eight* (not-less))
	(,*seven* (not-less))
	(,*six*   (not-less))
	(,*five*  (not-less))
	(,*four*  (less))
	(,*three* (less))
	(,*two*   (less))
	(,*one*   (less))
	))

(setq *bogus-four* '(1 1 0 1 1 1 0))	;erroneous samples
(setq *bogus-seven* '(0 0 1 1 1 1 0))	; from Winston

(define-training-data *input-ranges* *digit-output-ranges* *digit-data*)

#|
(define-training-data *input-ranges* '((odd even)) *odd-even-data*)

(define-training-data *input-ranges* '((not-less less)) *less-than-five-data*)
|#
