package aspectEditor.editors;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class AspectScanner extends RuleBasedScanner {
	public static String[] keys = {"chosen","selector","class","dictionary","{","}",";","aspect","=",".","(Traversal)","declare","strategy",":","->", "||", 
			                      "&&", "!","toStop","strategies","from","via","to","->", "nodes", "regexp","bypassing","node","set","and(","(",")",","};
	public AspectScanner(ColorManager manager) {
		IToken defaultText = new Token(new TextAttribute(manager.getColor(ColorConstants.DEFAULT)));
		/*IToken procInstr =
			new Token(
				new TextAttribute(
					manager.getColor(ColorConstants.PROC_INSTR)));
		*/
		IToken keyword =
			new Token(
				new TextAttribute(
					manager.getColor(ColorConstants.KEYWORD)));

		List rules = new ArrayList();
		
		//list of single line rules for things that weren't caught by the WordRule array
		WordRule wordRule = new WordRule(new InputWordDetector(), defaultText);
		SingleLineRule sl1= new SingleLineRule("or","(",keyword);
		SingleLineRule sl2= new SingleLineRule("and","(",keyword);
		SingleLineRule sl3= new SingleLineRule("(","Traversal",keyword);
		SingleLineRule sl4= new SingleLineRule("{","source",keyword);
		rules.add(sl1);
		rules.add(sl2);
		rules.add(sl3);
		rules.add(sl4);
		for (int i = 0; i < keys.length; i++) {
			wordRule.addWord(keys[i], keyword);
		}
		rules.add(wordRule);
		IRule[] result = new IRule[rules.size()];
		rules.toArray(result);
		setRules(result);
		
	}
}
