/*
 * Decompiled with CFR 0.152.
 */
package aspectEditor.aspectEditorUtils;

import aspectEditor.aspectEditorUtils.ClassDictionaryL;
import aspectEditor.aspectEditorUtils.ClassDictionaryName;
import aspectEditor.aspectEditorUtils.NodeSubsetName;
import aspectEditor.aspectEditorUtils.ParseException;
import aspectEditor.aspectEditorUtils.Parser;
import aspectEditor.aspectEditorUtils.SelectorL;
import aspectEditor.aspectEditorUtils.SelectorName;
import aspectEditor.aspectEditorUtils.StrategyName;
import aspectEditor.aspectEditorUtils.UniversalVisitor;
import aspectEditor.aspectEditorUtils.XAspectLanguage2;
import edu.neu.ccs.demeter.dj.ClassGraph;
import edu.neu.ccs.demeter.dj.Visitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class Main {
    public static Main parse(Reader in) throws ParseException {
        return new Parser(in)._Main();
    }

    public static Main parse(InputStream in) throws ParseException {
        return new Parser(in)._Main();
    }

    public static Main parse(String s) {
        try {
            return Main.parse(new StringReader(s));
        }
        catch (ParseException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static void main(String[] args) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            XAspectLanguage2 s = XAspectLanguage2.parse(in);
            Main.checkSemantics(s);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void checkSemantics(XAspectLanguage2 s) {
        boolean semanticError = false;
        ClassGraph cg = new ClassGraph(true, false);
        String sg_path = "./semanticChecker.jar";
        try {
            JarFile jf = new JarFile(new File(sg_path));
            Enumeration<JarEntry> enu = jf.entries();
            while (enu.hasMoreElements()) {
                String entry = ((Object)enu.nextElement()).toString();
                if (entry.indexOf("class") == -1) continue;
                entry = entry.replace('/', '.');
                int last_dot = entry.lastIndexOf(".class");
                entry = entry.substring(0, last_dot);
                Class<?> cl = Class.forName(entry);
                cg.addClass(cl);
            }
        }
        catch (Exception e) {
            System.out.println("open error");
        }
        Enumeration aspectEnumeration = s.get_aspectlanguage_list().elements();
        HashSet<Object> cdNames = new HashSet<Object>();
        while (aspectEnumeration.hasMoreElements()) {
            Object currObj = aspectEnumeration.nextElement();
            String cdType = "aspectEditor.semanticChecker.ClassDictionaryL";
            String traversalType = "aspectEditor.semanticChecker.SelectorL";
            if (cdType.equals(currObj.getClass().getName())) {
                Visitor cdnamev = new Visitor(){
                    Object cdname = new Object();

                    void before(ClassDictionaryName cdName) {
                        this.cdname = cdName.get_ident();
                    }

                    public Object getReturnValue() {
                        return this.cdname;
                    }
                };
                cg.traverse((Object)s, "from * via aspectEditor.semanticChecker.ClassDictionaryL to *", cdnamev);
                Object cdNameHash = cdnamev.getReturnValue();
                cdNames.add(cdNameHash);
                ClassDictionaryL currDict = (ClassDictionaryL)currObj;
                edu.neu.ccs.demeter.aplib.cd.ClassGraph inputcg = edu.neu.ccs.demeter.aplib.cd.ClassGraph.parse((String)currDict.get_classdict().get_text().toString());
                inputcg = inputcg.normalize();
                HashSet usedClasses = new HashSet(inputcg.getNodes());
                Iterator usedIterator = usedClasses.iterator();
                while (usedIterator.hasNext()) {
                    Object currClass = usedIterator.next();
                    if (inputcg.definesClass(currClass.toString())) continue;
                    System.out.println();
                    System.out.println("Semantic Error: The class " + currClass.toString() + " is used, but not defined.");
                    semanticError = true;
                }
            }
            if (!traversalType.equals(currObj.getClass().getName())) continue;
            SelectorL currSelector = (SelectorL)currObj;
            Visitor selectorv = new Visitor(){
                final HashSet selnamehash = new HashSet();

                void before(SelectorName selectorName) {
                    this.selnamehash.add(selectorName.get_ident());
                }

                public Object getReturnValue() {
                    return this.selnamehash;
                }
            };
            Visitor strategyv = new Visitor(){
                final HashSet stratnamehash = new HashSet();

                void before(StrategyName strategyName) {
                    this.stratnamehash.add(strategyName.get_name());
                }

                public Object getReturnValue() {
                    return this.stratnamehash;
                }
            };
            Visitor subsetnamev = new Visitor(){
                final HashSet subsetnamehash = new HashSet();

                void before(NodeSubsetName subsetName) {
                    this.subsetnamehash.add(subsetName.get_name());
                }

                public Object getReturnValue() {
                    return this.subsetnamehash;
                }
            };
            Visitor subsetnamev2 = new Visitor(){
                final HashSet subsetnamehash = new HashSet();

                void before(NodeSubsetName subsetName) {
                    this.subsetnamehash.add(subsetName.get_name());
                }

                public Object getReturnValue() {
                    return this.subsetnamehash;
                }
            };
            Visitor strategynamev = new Visitor(){
                final HashSet strategynamehash = new HashSet();

                void before(StrategyName strategyName) {
                    this.strategynamehash.add(strategyName.get_name());
                }

                public Object getReturnValue() {
                    return this.strategynamehash;
                }
            };
            cg.traverse((Object)s, "from * to *", selectorv);
            HashSet selNameHash = (HashSet)selectorv.getReturnValue();
            cg.traverse((Object)s, "from * through aspectEditor.semanticChecker.StrategyDef to *", strategyv);
            HashSet stratNameHash = (HashSet)strategyv.getReturnValue();
            cg.traverse((Object)s, "from aspectEditor.semanticChecker.XAspectLanguage2 bypassing aspectEditor.semanticChecker.NodeSubsetExpression to-stop aspectEditor.semanticChecker.NodeSubsetName", subsetnamev);
            HashSet subsetNameHashDecl = (HashSet)subsetnamev.getReturnValue();
            cg.traverse((Object)s, "from * via aspectEditor.semanticChecker.NodeSubsetExpression to *", subsetnamev2);
            HashSet subsetNameHashUsed = (HashSet)subsetnamev2.getReturnValue();
            cg.traverse((Object)s, "from * through aspectEditor.semanticChecker.GraphNodes to *", strategynamev);
            HashSet strategyNameHash = (HashSet)strategynamev.getReturnValue();
            Iterator selectorNameI = selNameHash.iterator();
            while (selectorNameI.hasNext()) {
                Object currSelectorN = selectorNameI.next();
                if (stratNameHash.contains(currSelectorN)) continue;
                System.out.println("Semantic Error: There is not a strategy named (Selector Name Error): " + currSelectorN.toString());
                semanticError = true;
            }
            Iterator strategyNameI = strategyNameHash.iterator();
            while (strategyNameI.hasNext()) {
                Object currStrategyN = strategyNameI.next();
                if (stratNameHash.contains(currStrategyN)) continue;
                System.out.println("Semantic Error: There is not a strategy named (Node Set Error): " + currStrategyN.toString());
                semanticError = true;
            }
            Iterator subsetNameI = subsetNameHashUsed.iterator();
            while (subsetNameI.hasNext()) {
                Object currSubsetN = subsetNameI.next();
                if (subsetNameHashDecl.contains(currSubsetN)) continue;
                System.out.println("Semantic Error: There is not a strategy named (Node Subset Error): " + currSubsetN.toString());
                semanticError = true;
            }
            Visitor cdnamev2 = new Visitor(){
                HashSet cdname = new HashSet();

                void before(ClassDictionaryName cdName) {
                    this.cdname.add(cdName.get_ident());
                }

                public Object getReturnValue() {
                    return this.cdname;
                }
            };
            cg.traverse((Object)s, "from * bypassing aspectEditor.semanticChecker.ClassDictionaryL to *", cdnamev2);
            HashSet cdNameHash2 = (HashSet)cdnamev2.getReturnValue();
            Iterator cdNameI = cdNameHash2.iterator();
            while (cdNameI.hasNext()) {
                Object currcdN = cdNameI.next();
                if (cdNames.contains(currcdN)) continue;
                System.out.println("Semantic Error: There is no class dictionary named (chosen class dictionary Error): " + currcdN.toString());
                semanticError = true;
            }
        }
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        this.universal_trv0_aft(_v_);
    }
}

