/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.dj;

import edu.neu.ccs.demeter.aplib.EdgeI;
import edu.neu.ccs.demeter.aplib.Traversal;
import edu.neu.ccs.demeter.aplib.cd.Part;
import edu.neu.ccs.demeter.dj.FetchException;
import edu.neu.ccs.demeter.dj.ObjectGraph;
import edu.neu.ccs.demeter.dj.ObjectGraphSlice;
import edu.neu.ccs.demeter.dj.Strategy;
import edu.neu.ccs.demeter.dj.Traversal;
import edu.neu.ccs.demeter.dj.TraversalException;
import edu.neu.ccs.demeter.dj.Visitor;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassGraph
extends edu.neu.ccs.demeter.aplib.cd.ClassGraph {
    static String version = "DJ version 0.8.6";
    public static boolean debug = false;
    boolean fields = true;
    boolean methods = true;
    protected Set packages = new HashSet();
    protected Map classesAdded = new HashMap();
    protected Map namesClasses = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$edu$neu$ccs$demeter$dj$Collection;

    public static String getVersion() {
        return version;
    }

    public static String version() {
        return ClassGraph.getVersion();
    }

    public ClassGraph() {
        this("");
    }

    public ClassGraph(String pkg) {
        this(pkg, true, true);
    }

    public ClassGraph(boolean f, boolean m) {
        this("", f, m);
    }

    public ClassGraph(String pkg, boolean f, boolean m) {
        this.fields = f;
        this.methods = m;
        this.addClass(class$java$lang$Object == null ? (class$java$lang$Object = ClassGraph.class$("java.lang.Object")) : class$java$lang$Object, false, false);
        this.addPackage(pkg);
        this.addClass(class$java$util$Collection == null ? (class$java$util$Collection = ClassGraph.class$("java.util.Collection")) : class$java$util$Collection, false, false);
        this.addRepetitionEdge("java.util.Collection", "java.lang.Object");
        this.addClass(class$edu$neu$ccs$demeter$dj$Collection == null ? (class$edu$neu$ccs$demeter$dj$Collection = ClassGraph.class$("edu.neu.ccs.demeter.dj.Collection")) : class$edu$neu$ccs$demeter$dj$Collection, false, false);
        this.addRepetitionEdge("edu.neu.ccs.demeter.dj.Collection", "java.lang.Object");
    }

    public ClassGraph(Traversal tg) {
        ClassGraph cg = (ClassGraph)tg.getClassGraph();
        Iterator edges = tg.getEdgeSets().iterator();
        while (edges.hasNext()) {
            EdgeI edge = ((Traversal.EdgeSet)edges.next()).getEdge();
            Class cl = cg.getNodeClass(edge.getSource());
            this.namesClasses.put(cl.getName(), cl);
            EdgeI newedge = this.addEdge(edge);
            if (!(edge instanceof Part) || !((Part)edge).isDerived()) continue;
            ((Part)newedge).markDerived();
        }
    }

    public ClassGraph(ClassGraph cg, Strategy s) throws TraversalException {
        this(new Traversal(s, cg));
    }

    public ClassGraph(ClassGraph cg, String s) throws TraversalException {
        this(cg, new Strategy(s));
    }

    public void addPackage(String p) {
        if (!this.packages.add(p)) {
            return;
        }
        String pkgprefix = p.equals("") ? "" : p + ".";
        String pkgdir = p.replace('.', File.separatorChar);
        String classpath = System.getProperty("java.class.path");
        int i = 0;
        while (i < classpath.length()) {
            int j = classpath.indexOf(File.pathSeparatorChar, i);
            if (j == -1) {
                j = classpath.length();
            }
            File path = new File(classpath.substring(i, j));
            i = j;
            if (path.isDirectory()) {
                File[] classfiles;
                File classdir = new File(path, pkgdir);
                if (debug) {
                    System.out.println("Searching " + classdir);
                }
                if ((classfiles = classdir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".class");
                    }
                })) != null) {
                    int n = 0;
                    while (n < classfiles.length) {
                        File classfile = classfiles[n];
                        String clname = classfile.getName();
                        clname = pkgprefix + clname.substring(0, clname.length() - 6);
                        try {
                            Class<?> cl = Class.forName(clname);
                            if (debug) {
                                System.out.println("Adding " + cl);
                            }
                            this.addClass(cl);
                        }
                        catch (ClassNotFoundException e) {
                            System.err.println("Warning: found " + classfile + " but could not load class " + clname + ".");
                        }
                        ++n;
                    }
                }
            }
            ++i;
        }
    }

    public void addClass(Class cl) {
        this.addClass(cl, this.fields, this.methods);
    }

    public void addClass(Class cl, boolean addFields, boolean addMethods) {
        int mod;
        int i;
        this.namesClasses.put(cl.getName(), cl);
        Added added = (Added)this.classesAdded.get(cl);
        if (!(added == null || !added.fields && addFields || !added.methods && addMethods)) {
            return;
        }
        boolean addSupers = false;
        if (added == null) {
            added = new Added();
            this.classesAdded.put(cl, added);
            addSupers = true;
        }
        addFields = addFields && !added.fields;
        addMethods = addMethods && !added.methods;
        String name = cl.getName();
        if (addFields) {
            added.fields = true;
            Field[] fields = cl.getDeclaredFields();
            i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                mod = field.getModifiers();
                if (!Modifier.isStatic(mod)) {
                    if (debug) {
                        System.out.println("Adding " + field);
                    }
                    this.addConstructionEdge(name, field);
                }
                ++i;
            }
        }
        if (addMethods) {
            added.methods = true;
            Method[] methods = cl.getDeclaredMethods();
            if (debug) {
                System.out.println(Arrays.asList(methods));
            }
            i = 0;
            while (i < methods.length) {
                Method method = methods[i];
                mod = method.getModifiers();
                if (!Modifier.isStatic(mod) && method.getParameterTypes().length == 0 && !method.getName().equals("clone")) {
                    if (debug) {
                        System.out.println("Adding " + method);
                    }
                    this.addConstructionEdge(name, method);
                }
                ++i;
            }
        }
        if (addSupers) {
            Class rep = ClassGraph.getRepetitionType(cl);
            if (rep == null) {
                Class sup = cl.getSuperclass();
                if (sup != null) {
                    String supname = sup.getName();
                    this.addAlternationEdge(supname, name);
                    this.addInheritanceEdge(name, supname);
                    this.addClass(sup, false, false);
                }
                Class<?>[] interfaces = cl.getInterfaces();
                int i2 = 0;
                while (i2 < interfaces.length) {
                    String ifname = interfaces[i2].getName();
                    this.addAlternationEdge(ifname, name);
                    this.addInheritanceEdge(name, ifname);
                    this.addClass(interfaces[i2], false, false);
                    ++i2;
                }
            } else {
                this.addRepetitionEdge(name, rep.getName());
                this.addAlternationEdge("java.lang.Object", name);
                this.addInheritanceEdge(name, "java.lang.Object");
            }
        }
    }

    public Part addConstructionEdge(Field field) {
        return this.addConstructionEdge(field.getDeclaringClass().getName(), field);
    }

    public Part addConstructionEdge(Method method) {
        return this.addConstructionEdge(method.getDeclaringClass().getName(), method);
    }

    public Part addConstructionEdge(String source, Field field) {
        return this.addConstructionEdge(source, ClassGraph.edgeLabel(field), ClassGraph.edgeTarget(field));
    }

    public Part addConstructionEdge(String source, Method method) {
        Part edge = this.addConstructionEdge(source, ClassGraph.edgeLabel(method), ClassGraph.edgeTarget(method));
        if (edge != null) {
            edge.markDerived();
        }
        return edge;
    }

    /*
     * Unable to fully structure code
     */
    public Part addConstructionEdge(String source, String label, Class target) {
        if (!target.equals(Void.TYPE)) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            target = target.getComponentType();
lbl4:
            // 2 sources

            ** while (target.isArray())
        }
lbl5:
        // 1 sources

        this.namesClasses.put(target.getName(), target);
        ret = this.addConstructionEdge(source, label, target.getName());
        this.addClass(target, false, false);
        return ret;
    }

    static boolean isCollectionClass(Class cl) {
        return (class$edu$neu$ccs$demeter$dj$Collection == null ? (class$edu$neu$ccs$demeter$dj$Collection = ClassGraph.class$("edu.neu.ccs.demeter.dj.Collection")) : class$edu$neu$ccs$demeter$dj$Collection).isAssignableFrom(cl) || (class$java$util$Collection == null ? (class$java$util$Collection = ClassGraph.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(cl);
    }

    static Class getRepetitionType(Class cl) {
        try {
            Field f = cl.getDeclaredField("_repeatedPart");
            int m = f.getModifiers();
            if (Modifier.isPrivate(m) && Modifier.isStatic(m)) {
                return f.getType();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public void addRepetitionEdge(String source, String target) {
        this.addConstructionEdge(source, ClassGraph.repetitionEdgeLabel(), target);
    }

    public static boolean isRepetitionEdge(EdgeI edge) {
        return edge.isConstructionEdge() && edge.getLabel().equals(ClassGraph.repetitionEdgeLabel());
    }

    static String repetitionEdgeLabel() {
        return "elements";
    }

    public Class getNodeClass(Object node) {
        return (Class)this.namesClasses.get(String.valueOf(node));
    }

    public Class getClassNamed(String name) {
        return (Class)this.namesClasses.get(name);
    }

    public ObjectGraphSlice slice(Object o, Strategy s) {
        return new ObjectGraph(o, this).slice(s);
    }

    public ObjectGraphSlice slice(Object o, String s) {
        return new ObjectGraph(o, this).slice(s);
    }

    public Object traverse(Object o, Strategy s, Visitor v) {
        return this.slice(o, s).traverse(new Visitor[]{v});
    }

    public Object traverse(Object o, Strategy s, Visitor[] v) {
        return this.slice(o, s).traverse(v);
    }

    public Object fetch(Object o, Strategy s) throws FetchException {
        return this.slice(o, s).fetch();
    }

    public List gather(Object o, Strategy s) {
        return this.slice(o, s).gather();
    }

    public List asList(Object o, Strategy s) {
        return this.slice(o, s).asList();
    }

    public Object traverse(Object o, String s, Visitor v) {
        return this.slice(o, s).traverse(new Visitor[]{v});
    }

    public Object traverse(Object o, String s, Visitor[] v) {
        return this.slice(o, s).traverse(v);
    }

    public Object fetch(Object o, String s) throws FetchException {
        return this.slice(o, s).fetch();
    }

    public List gather(Object o, String s) {
        return this.slice(o, s).gather();
    }

    public List asList(Object o, String s) {
        return this.slice(o, s).asList();
    }

    static String edgeLabel(Field field) {
        return ClassGraph.fieldEdgeLabel(field.getName());
    }

    static String fieldEdgeLabel(String name) {
        return name;
    }

    static String edgeLabel(Method method) {
        return ClassGraph.methodEdgeLabel(method.getName());
    }

    static String methodEdgeLabel(String name) {
        return name;
    }

    boolean isDerivedEdge(EdgeI edge) {
        return edge instanceof Part && ((Part)edge).isDerived();
    }

    static String memberName(EdgeI edge) {
        return edge.getLabel();
    }

    static Class edgeTarget(Field field) {
        return field.getType();
    }

    static Class edgeTarget(Method method) {
        return method.getReturnType();
    }

    public static void main(String[] args) {
        ClassGraph cg = new ClassGraph();
        cg.addPackage("edu.neu.ccs.demeter.dj");
        cg.addPackage("edu.neu.ccs.demeter.aplib");
        cg.addPackage("edu.neu.ccs.demeter.aplib.cd");
        System.out.println(cg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class Added {
        boolean fields;
        boolean methods;

        protected Added() {
        }
    }
}

