/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.common.tg;

import edu.neu.ccs.demeter.common.tg.AEdge;
import edu.neu.ccs.demeter.common.tg.CEdge;
import edu.neu.ccs.demeter.common.tg.Edge;
import edu.neu.ccs.demeter.common.tg.IEdge;
import edu.neu.ccs.demeter.common.tg.Mark;
import edu.neu.ccs.demeter.common.tg.NameI;
import edu.neu.ccs.demeter.common.tg.PrintVisitor;
import edu.neu.ccs.demeter.common.tg.StrategyGraphI;
import edu.neu.ccs.demeter.common.tg.TraversalGraph;
import edu.neu.ccs.demeter.common.tg.UniversalVisitor;
import edu.neu.ccs.demeter.common.tg.Vertex;
import edu.neu.ccs.demeter.common.tg.Vertex_DList;
import edu.neu.ccs.demeter.common.tg.int_int_Pair;
import edu.neu.ccs.demeter.common.tg.int_int_Pair_List;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClassGraph {
    protected Vertex_DList vertices;
    static int curTrav = 0;
    static int curSGsize = 0;
    static TraversalGraph curTG = null;
    static TraversalGraph curForwTG = null;
    Hashtable vertexdict;

    public Vertex_DList get_vertices() {
        return this.vertices;
    }

    public void set_vertices(Vertex_DList new_vertices) {
        this.vertices = new_vertices;
    }

    public ClassGraph(Vertex_DList vertices) {
        this.set_vertices(vertices);
    }

    public void addConstructionEdge(NameI source, NameI name, NameI dest) {
        CEdge e = new CEdge();
        e.set_name(name);
        this.addEdge(e, source, dest);
    }

    public void addAlternationEdge(NameI source, NameI dest) {
        this.addEdge(new AEdge(), source, dest);
    }

    public void addInheritanceEdge(NameI source, NameI dest) {
        this.addEdge(new IEdge(), source, dest);
    }

    public TraversalGraph computeTraversalGraph(StrategyGraphI sg, Dictionary nameMap) {
        ++curTrav;
        curSGsize = sg.numEdges();
        curTG = new TraversalGraph();
        curForwTG = new TraversalGraph();
        final Dictionary fmap = nameMap;
        Hashtable map = new Hashtable(){

            public Object get(Object sgName) {
                Object cgName;
                if (fmap == null || (cgName = fmap.get(sgName)) == null) {
                    return sgName;
                }
                return cgName;
            }
        };
        this.addIntercopyEdges(sg, map);
        ClassGraph.unmarkAllForward();
        ClassGraph.unmarkAllBackward();
        Enumeration sources = sg.getSources();
        Enumeration targets = sg.getTargets();
        if (sources == null && curSGsize == 1 && targets != null) {
            ClassGraph.markAllForward();
        } else {
            if (sources == null) {
                sources = this.vertices();
            }
            while (sources.hasMoreElements()) {
                this.markReachableForwardFrom((NameI)sources.nextElement(), sg, map);
            }
        }
        if (targets == null && curSGsize == 1) {
            ClassGraph.markAllBackward();
            curTG = curForwTG;
        } else {
            if (targets == null) {
                targets = this.vertices();
            }
            while (targets.hasMoreElements()) {
                this.markReachableBackwardFrom((NameI)targets.nextElement(), sg, map);
            }
        }
        return curTG;
    }

    public Vertex findVertex(NameI c) {
        return (Vertex)this.vertexdict.get(c);
    }

    public Vertex findVertex(NameI c, boolean add) {
        Vertex v = this.findVertex(c);
        if (v == null && add) {
            v = new Vertex(c);
            this.addVertex(v);
        }
        return v;
    }

    public ClassGraph() {
        this.vertexdict = new Hashtable();
        this.vertices = new Vertex_DList();
    }

    void addVertex(Vertex v) {
        this.vertices.addElement(v);
        this.vertexdict.put(v.get_name(), v);
    }

    void addEdge(Edge e) {
        e.get_source().addOutgoing(e);
        e.get_dest().addIncoming(e);
    }

    void addEdge(Edge e, NameI source, NameI dest) {
        e.set_source(this.findVertex(source, true));
        e.set_dest(this.findVertex(dest, true));
        this.addEdge(e);
    }

    Enumeration vertices() {
        return this.vertexdict.keys();
    }

    static void markAllForward() {
        Mark.all_forw = true;
    }

    static void markAllBackward() {
        Mark.all_back = true;
    }

    static void unmarkAllForward() {
        Mark.all_forw = false;
    }

    static void unmarkAllBackward() {
        Mark.all_back = false;
    }

    public void addIntercopyEdges(StrategyGraphI sg, Dictionary nameMap) {
        Enumeration sgVertices = sg.getVertices();
        while (sgVertices.hasMoreElements()) {
            NameI sgv = (NameI)sgVertices.nextElement();
            Vector incoming = sg.getIncomingIndices(sgv);
            Vector outgoing = sg.getOutgoingIndices(sgv);
            NameI cgv = (NameI)nameMap.get(sgv);
            Vertex tgv = this.findVertex(cgv);
            if (tgv == null) {
                System.err.println("Warning: class graph has no class \"" + cgv + "\".");
                continue;
            }
            tgv.get_intercopyEdges().append(this.crossProduct(incoming, outgoing));
        }
    }

    int_int_Pair_List crossProduct(Vector v1, Vector v2) {
        int_int_Pair_List prod = new int_int_Pair_List();
        if (v1.isEmpty() || v2.isEmpty()) {
            return prod;
        }
        Enumeration e1 = v1.elements();
        while (e1.hasMoreElements()) {
            Integer x = (Integer)e1.nextElement();
            Enumeration e2 = v2.elements();
            while (e2.hasMoreElements()) {
                Integer y = (Integer)e2.nextElement();
                prod.addElement(new int_int_Pair(x, y));
            }
        }
        return prod;
    }

    public void markReachableForwardFrom(NameI sgVertex, StrategyGraphI sg, Dictionary nameMap) {
        NameI cgVertex = (NameI)nameMap.get(sgVertex);
        Vertex v = this.findVertex(cgVertex, false);
        if (v == null) {
            System.err.println("Error: no such source class, \"" + cgVertex + "\"");
        } else {
            Vector indices = sg.getOutgoingIndices(sgVertex);
            Enumeration e = indices.elements();
            while (e.hasMoreElements()) {
                Integer i = (Integer)e.nextElement();
                v.markReachableForward(sg, i, nameMap);
            }
        }
    }

    public void markReachableBackwardFrom(NameI sgVertex, StrategyGraphI sg, Dictionary nameMap) {
        NameI cgVertex = (NameI)nameMap.get(sgVertex);
        Vertex v = this.findVertex(cgVertex, false);
        if (v == null) {
            System.err.println("Error: no such target class, \"" + cgVertex + "\"");
        } else {
            Vector indices = sg.getIncomingIndices(sgVertex);
            Enumeration e = indices.elements();
            while (e.hasMoreElements()) {
                Integer i = (Integer)e.nextElement();
                v.markReachableBackward(sg, i, nameMap);
            }
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.toAll(new PrintVisitor(new PrintWriter((Writer)sw, true)));
        return sw.toString();
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        _v_.before_vertices(this, this.vertices);
        this.vertices.universal_trv0(_v_);
        _v_.after_vertices(this, this.vertices);
        this.universal_trv0_aft(_v_);
    }

    public void toAll(UniversalVisitor __v0) {
        this.toAll_ClassGraph_trv(__v0);
    }

    void toAll_ClassGraph_trv_bef(UniversalVisitor __v0) {
        __v0.before(this);
    }

    void toAll_ClassGraph_trv_aft(UniversalVisitor __v0) {
        __v0.after(this);
    }

    void toAll_ClassGraph_trv(UniversalVisitor __v0) {
        this.toAll_ClassGraph_trv_bef(__v0);
        __v0.before_vertices(this, this.vertices);
        this.vertices.toAll_ClassGraph_trv(__v0);
        __v0.after_vertices(this, this.vertices);
        this.toAll_ClassGraph_trv_aft(__v0);
    }
}

