package org.webjinn.utils;
import java.util.*;
import java.io.*;

public class Parser {
  private char[] file;
  private String[] tags;
  private int pos=0;
  private Vector elements;

  private String curTagType;
  private String curAttributes;
  private char[] curBody;
  private boolean[] hasBodies;

	public Parser(String text,String[] tags, boolean[] hasBodies) {
		file = getChars(text);
    this.tags=tags;
    this.hasBodies = hasBodies;		
	}

  public Parser(char[] file,String[] tags,boolean[] hasBodies) {
    this.file = file;
    this.tags=tags;
    this.hasBodies = hasBodies;
  }

  public Element[] getElements() {
   if (elements!=null)
    return (Element[])elements.toArray(new Element[0]);
   else
    return new Element[0];
  }

  public class Element {
   private String type;
   private Hashtable attributes=null;
   private char[] body=null;
   private Vector elements=null;

   public String getType() {
    return type;
   }
  
   public Element[] getChildren() {
    if (elements!=null)
     return (Element[])elements.toArray(new Element[0]);
    else
     return new Element[0];
   }

   public char[] getBody() {
    return body;
   }

	 public String getBodyAsString() {
		 return new String(body);
	 }


   public void setBody(char[] body) {
    this.body=body;
   }
	 
   public void setBody(String body) {
    this.body=getChars(body);
   }


   public void setAttributes(String attributes) {
     this.attributes=parseAttributes(attributes);
   }

   public void setAttribute(String name,String value) {
     attributes.put(name.toLowerCase(),value);
   }

   public String getAttribute(String name) {
    try {
     return (String)attributes.get(name.toLowerCase());
     } catch (Exception e) {return null;}
   }

   public Hashtable getAttributes() {
     return attributes;
   }
   
   public void parseBody(String[] tags,boolean[] hasBodies) {
     if (body!=null && body.length>0) {
      Parser p = new Parser(body,tags,hasBodies);
      p.parse();
      this.elements = p.elements;
     }
   }

   public String getAsTag() {
    if (type.equalsIgnoreCase("text")) {if (body!=null) return new String(body); else return null;}
    String result = "<"+type;
    if (attributes!=null) {
      Enumeration attrNames=attributes.keys();
      while (attrNames.hasMoreElements()) {
       String attrName = (String)attrNames.nextElement();
       result=result+" "+attrName+"=\""+(String)attributes.get(attrName)+"\"";
      }
    }
    if (body==null) {return result+"/>";} 
    else {
      result=result+">";
      if (elements==null) {return result+new String(body)+"</"+type+">";} 
      else {
        for (int i=0;i<elements.size();i++) {
          Element el=(Element)elements.get(i);
          result = result+el.getAsTag();
        }
        result = result + "</"+type+">";
        return result;
      } 
    }
   }

   public char[] getTag() {
    if (type.equalsIgnoreCase("text")) {
     if (body!=null) return body; else return new char[0];
    }
    String str = getAsTag();
    if (str==null) return null;
    char[] result = new char[str.length()];
    str.getChars(0,str.length(),result,0);
    return result;
   }

   private Hashtable parseAttributes(String attributes) {
    if (attributes==null || attributes.length()==0) return null;
       Hashtable result=new Hashtable();
       replace(attributes,"\n"," ");       
       replace(attributes,"\r"," ");
       while (attributes.indexOf(" =")>=0) attributes=replace(attributes," =","=");
       while (attributes.indexOf("= ")>=0) attributes=replace(attributes,"= ","=");
       while (attributes.indexOf("  ")>=0) attributes=replace(attributes,"  "," ");
       StringTokenizer st = new StringTokenizer(attributes);
       while (st.hasMoreTokens()) {
          String pair = st.nextToken();
          StringTokenizer params = new StringTokenizer(pair,"=");
          String name=null;
          String value="";
          try{
           name = params.nextToken();
           value = params.nextToken();
	   if ( 
           (value.indexOf("\"")==0 && value.lastIndexOf("\"")==(value.length()-1) ) || 
           (value.indexOf("'")==0  && value.lastIndexOf("'")==(value.length()-1)  )
              ) 
             value = value.substring(1,(value.length()-1));
          } catch (Exception e) {}
          if (name!=null) {result.put(name.toLowerCase(),value);}
       }
       if (result.size()>0) return result; else return null;
   }

  }

  protected int getNextPoint(int type) {
   int x1,x2,x3,x4;
   if (type==0) { 

     while (true) {
       if ((x1 = getNextPosition('<',false,true))==-1) return -1;
       pos++;
       if (getNextPosition(' ',false,false)==-1) continue;
       x2=pos;
       while (pos<file.length && (Character.isLetterOrDigit(file[pos]) || file[pos]=='_') || file[pos]==':') pos=pos+1;
       if (x2==pos) continue;

        x3=pos; 
       if (!isMatchedTag(x2,x3)) continue;
       if ((x4 = getNextPosition('>',false,true))==-1) continue;
       if (file[x4-1]=='/') x4=x4-1;

       if ((x4-x3)>0) {curAttributes=new String(file,x3,x4-x3);} else curAttributes="";
       pos++;
       return x1;
     }
   }

   if (type==1) { 
    x1 = pos;
    while (true) {
       if ((x2=getNextPosition('<',false,true))==-1) return -1;
       pos++;
       x3=pos; 
       if (x3>=(file.length-1)) return -1;
       if (file[x3]!='/') continue;
       pos=pos+1;
       if (getNextPosition(' ',false,false)==-1) continue;
       x3=pos;
       while (pos<file.length && (Character.isLetterOrDigit(file[pos]) || file[pos]=='_') || file[pos]==':') pos=pos+1;
       if (x3==pos) continue;

        x4=pos; 
        if (!curTagType.equalsIgnoreCase(new String(file,x3,x4-x3))) continue;
       if (getNextPosition(' ',false,false)==-1) continue;
       if (file[pos]!='>') continue;
       else { 
          curBody = new char[x2-x1];
          System.arraycopy(file,x1,curBody,0,x2-x1);
          pos=pos+1;
          return pos-1;           
       }
    }      
   }
   return -1;
  }

  private int getNextPosition (char symbol,boolean inLine,boolean isChar) {
       int result=pos;
       while (
           pos<file.length && 
           ((isChar && file[pos]!=symbol) || (!isChar && ((inLine && file[pos]==symbol) || (!inLine && (file[pos]==symbol || file[pos]=='\r' || file[pos]=='\n') ) ) )) && 
           ((!inLine) || (file[pos]!='\r' && file[pos]!='\n')) 
             ) 
       {pos++;}
       if (pos==file.length || (inLine && (file[pos]=='\r' || file[pos]=='\n'))) return -1;    
       result=pos;
       return result;
  }

  private boolean isMatchedTag(int startName,int endName) {
   String name = new String (file,startName,endName-startName);
   for (int i=0;i<tags.length;i++)
   if (tags[i].equalsIgnoreCase(name)) {curTagType=name.toLowerCase(); return true;}
   return false;
  }  

	private char[] getChars(String str) {
    if (str==null) return new char[0];
		char[] result = new char[str.length()];
		str.getChars(0,str.length(),result,0);
		return result;
	}


  public void parse() {
   int x1,x2;
   pos=0;
   elements = new Vector();
   Element el;
   int prev=0;

   while (pos<file.length) {
    el= new Element();
    if ((x1 = getNextPoint(0))==-1) {
      if (file.length>prev) {
        el.type="text";
        el.body=new char[file.length-prev];
        System.arraycopy(file,prev,el.body,0,file.length-prev);
        elements.add(el);
        prev = file.length;
      }
    } else {
      if (x1>prev) {
        Element ell=new Element();
        ell.type="text";
        ell.body=new char[x1-prev];
        System.arraycopy(file,prev,ell.body,0,x1-prev);
        elements.add(ell);
      }

      boolean hasBody=true;
      try {
        for (int i=0;i<tags.length;i++) 
        if (tags[i].equalsIgnoreCase(curTagType)) {hasBody=hasBodies[i]; break;}
      } catch (Exception e) {}

      if (file[pos-2]=='/' || !hasBody) { 
        el.type=curTagType;
        el.setAttributes(curAttributes);
        el.body=null;
        elements.add(el);     
        prev = pos;
      } else { 
        if ((x2=getNextPoint(1))==-1) continue; 
        el.type=curTagType;
        el.setAttributes(curAttributes);
        el.body = curBody;
        elements.add(el);
        prev=pos;
      }

    } 

    } 
    
   } 

 public static String replace(String source,String oldsubstr,String newsubstr) {
   try{
     StringBuffer result = new StringBuffer(source.length());
     int i=0;
     int k=0;
     int l = oldsubstr.length();
     while ((i=source.indexOf(oldsubstr,i))>=0) {
      result=result.append(source.substring(k,i)).append(newsubstr);
      i=i+l;
      k=i;
     }
     result=result.append(source.substring(k));
     return result.toString();
   } catch (Exception e) {return null;}
 }

 public static char[] append(char[] arr1,char[] arr2) {
  if (arr1 == null) return arr2;
  if (arr2 == null) return arr1;
  char[] result = new char[arr1.length+arr2.length];
  System.arraycopy(arr1,0,result,0,arr1.length);
  System.arraycopy(arr2,0,result,arr1.length,arr2.length);
  return result;
 }

 public static void main(String[] args) {
 }
}
