package org.webjinn.cms.model;

/** Represents element of an interface tree */
public interface InterfaceTreeElement {

	/** Returns parent element for this element 
	 * or null if this element is a root element in the Interface */
	public InterfaceTreeElement getParent();

	/** Builds header code */
	public String buildHeader();

	/** Builds footer code */
	public String buildFooter();
	
	/** Returns element name */
	public String getName();

	/** Returns menu-uri of this Tree Element */
	public String getInterfaceURI();
}
