package org.webjinn.cms.actions;
import org.webjinn.cms.model.CMSTree;
import java.io.File;

/** Contains a number of auxiliary (static) methods 
 *  to be used by action classes */
class Utils {

	/** Returns absolute (system-dependent) file path to
	 * the root directory of a website WITHOUT closing file separator symbol. */
	protected static String getRootDir(CMSTree tree) {
		String rootDir = tree.getRootDir(); //must be absolute file name!
		//just in case
		rootDir = new File(rootDir).getAbsolutePath(); //To be removed?
		//
		if (rootDir.endsWith(File.separator)) 
			rootDir=rootDir.substring(0,rootDir.length()-1);		
		return rootDir;
	}

	/** Given file-uri from request returns its "normalized" form.
	 * More specifically, returns system-dependent file URI without
	 * leading file separator symbol */
	protected static String normalizeFileURI(String uri) {
		if (uri==null) 
			uri="";
		else {
			if (uri.startsWith("ROOT")) uri=uri.substring(4);
			//removing leading '/' if present
			if (uri.startsWith("/")) uri=uri.substring(1);
			//replacing '/' symbols with system-dependent file separator
			uri=uri.replace('/',File.separatorChar);
		}		
		return uri;
	}

	/** Given an absolute, system-dependent path to the root dir 
	 * and a File object (located under root dir) returns request-compatible
	 * uri for that File */ 
	protected static String getRequestURI(String rootDir,File f) {
    try{
      String path=f.getAbsolutePath().substring(rootDir.length());
      if (path.startsWith(File.separator)) path=path.substring(1);
			path = "ROOT/"+path.replace(File.separatorChar,'/');
      if (path.endsWith("/")) path=path.substring(0,path.length()-1);
      return path;
    } catch (Exception e) {
			return "";
		}		
	}

	protected static String getPageURI(String rootDir, File f) {
    try{
      String path=f.getAbsolutePath().substring(rootDir.length());
      if (path.startsWith(File.separator)) path=path.substring(1);
			path = path.replace(File.separatorChar,'/');
      if (path.endsWith("/")) path=path.substring(0,path.length()-1);
      return path;
    } catch (Exception e) {
			return "";
		}		
	}


}
