package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.InterfaceTreeElement;
import org.webjinn.cms.model.Page;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SelectFilesAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			CMSTree tree = getCMSTree();	
			String rootDir = Utils.getRootDir(tree);
			String uri = request.getParameter("uri");

			String fileURI = Utils.normalizeFileURI(uri);
			Vector records = new Vector();

			if (uri==null) uri="";
			if (uri.startsWith("ROOT")) uri=uri.substring(4);
			if (uri.startsWith("/")) uri=uri.substring(1);

			File[] files = new File(rootDir+File.separator+fileURI).listFiles();
			Page[] subpages = tree.getDirectoryPages(uri, false);
			Hashtable pages = new Hashtable(subpages.length);
			for (int i=0;i<subpages.length;i++) {
				pages.put(subpages[i].getFileURI(),subpages[i]);
			}

			for (int i=0;i<files.length;i++)
				if (!files[i].isDirectory()) {
					MappedBean record = new MappedBean();			
					record.setValue("name",files[i].getName());
					String pageURI = Utils.getPageURI(rootDir,files[i]);				
					record.setValue("pageURI",pageURI);
					Page page = (Page)pages.get(pageURI);

					if (page!=null) {
						InterfaceTreeElement el = page.getAssociatedElement();	
						//if el==null, smth is wrong, ignore it
						if (el!=null)  
							record.setValue("interfaceURI",el.getInterfaceURI());
					} 
					records.add(record);
				}
			request.setAttribute("files",records);
			return mapping.findForward("CONTENT");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("EXCEPTION");
		}
	}

}
