package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import java.io.File;

public class DelDirAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{			
			CMSTree tree = getCMSTree();			
			String rootDir = Utils.getRootDir(tree);
			String uri = request.getParameter("uri");
			String name = request.getParameter("name");
			String fileURI = Utils.normalizeFileURI(uri);
			File dir = new File(rootDir+File.separator+fileURI,name);
			String pageFilePrefix = Utils.getPageURI(rootDir,dir);
			tree.removePages(tree.getDirectoryPages(pageFilePrefix,true));
			deleteDir(dir);
			return mapping.findForward("SUCCESS");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("FAIL");
		}
	}

	private void deleteDir(File dir) {
		try{
			File[] files=dir.listFiles();
			if (files!=null)
				for (int i=0;i<files.length;i++) {
					try{	
						if (files[i].isDirectory()) deleteDir(files[i]); else files[i].delete();
					} catch (Exception exc) {}
				}
			dir.delete();
		} catch (Exception e) {}
	}


}
