package pattern.sitebuilder;
import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import webJinn.parser.parser;
import webJinn.parser.parser.Element;

public abstract class ResourceContainer {
  protected String conttype=null;
  protected long contid=-1;

  protected String resourceTag=null;
  protected javax.servlet.ServletContext context=null;
  protected webJinn.sql.SQLConnector connector=null;
  protected String rootDir=null;

  public ResourceContainer(javax.servlet.ServletContext context) {
    this.context=context;
    connector=(webJinn.sql.SQLConnector)context.getAttribute("_Connector");    
    rootDir = context.getRealPath("");
    if (rootDir.endsWith(File.separator)) rootDir=rootDir.substring(0,rootDir.length()-1);
  }

  public void setContId(long contid) { 
    this.contid=contid;
  }

  public void setContId(String contid) { 
   try{
    this.contid=Long.parseLong(contid);
   } catch (Exception e) {}
  }


  protected abstract File[] getContainerFiles();

  public abstract long getContainerID();

  public Hashtable getResources() {
    try{
      long contid=getContainerID();
      Hashtable resources=new Hashtable();
      File[] files=getContainerFiles();
      if (files==null) return resources;
      for (int k=0;k<files.length;k++) {
        File container=files[k];
        if (container==null || !container.exists()) continue;
        InputStreamReader reader=new InputStreamReader(new FileInputStream(container),"Cp1251");
        try{
          char[] file=null;
          char[] filePiece = new char[51200];
          int fileSize=0;
          int current=0;
          while ((current=reader.read(filePiece))>=0) {
            fileSize=fileSize+current;
            char[] buf=new char[fileSize];
            if (file!=null) System.arraycopy(file,0,buf,0,file.length);
            System.arraycopy(filePiece,0,buf,fileSize-current,current);
            file=buf;
          }
          boolean[] hasBodies={false};
          String[] tags=new String[1];
          tags[0]=resourceTag;
          parser p=new parser(file,tags,hasBodies);
          p.parse();
          if (p.elements!=null) 
            for (int i=0;i<p.elements.size();i++) {
              Element el = (Element)p.elements.get(i);
              try{
                if (el.type.equalsIgnoreCase(resourceTag)) {
                  Resource res=new Resource(el.getAttribute("name"),el.getAttribute("type"),contid,conttype);
                  res.setDescription(el.getAttribute("desc"));
                  resources.put(el.getAttribute("name"),res);
                }            
              } catch (Exception exc) {}
            }
        } finally{reader.close();}
      }
      return resources;
    } catch (Exception e) {return null;}
  }

  public void setResourceTag(String val) {
    resourceTag=val;
  }
  public String getResourceTag() {
    return resourceTag;
  }
  protected void saveToFile(File container,String content) {
    try{
      if (content==null) content="";
      if (!container.exists()) {
        container.mkdirs();
        container.createNewFile();
      }
      BufferedWriter writer=new BufferedWriter(new OutputStreamWriter(new FileOutputStream(container),"Cp1251"));
      try{
        writer.write(content);
      } finally {writer.close();}
    } catch (Exception e) {}
  }

  public static ResourceContainer instanciate(String conttype,javax.servlet.ServletContext context) {
   if (conttype.equals("item")) return new ItemContainer(context);
   if (conttype.equals("menu")) return new MenuContainer(context);
   if (conttype.equals("page")) return new PageContainer(context);
   return null;
  }
}
