package pattern.sitebuilder;
import java.sql.*;
import java.io.*;

/**Class represent application-layer representation of container resource.*/
public class Resource {
  /**Container id*/
  protected long contid=0;
  /**The type of the container (menu,menuitem or page)*/
  protected String conttype=null;
  /**The name of the resource*/
  protected String resname=null;
  /**The type of the resource (can be text,textarea or img)*/
  protected String restype;
  /**Resource description...*/
  protected String description=null;

  public Resource (String resname,String restype,long contid,String conttype) throws Exception {
    if (resname==null) throw new Exception("parse error: no resource name");
    this.resname=resname;
    if (restype==null) restype="text";
    this.restype=restype;
    this.contid=contid;
    this.conttype=conttype;
  }

  public webJinn.field.Field getField(Connection con) {
    try{
      webJinn.field.Field result=null;
      PreparedStatement pst=con.prepareStatement("Select res_INFO from _siteresources where name=? and type=? and master__id=? and mastertype=?");
      pst.setString(1,resname);
      pst.setString(2,restype);
      pst.setLong(3,contid);
      pst.setString(4,conttype);
      ResultSet rs=pst.executeQuery();
      if (rs.next()) {
        if (restype.equals("img")) {
          result=new webJinn.field.FileField(resname,null,rs.getString(1));
        } else {
          result=new webJinn.field.TextField(resname,rs.getString(1));
        }
      } 
      return result;
    } catch (Exception e) {return null;}
  }

  public long getResourceID(Connection con) {
    try{
      webJinn.field.Field result=null;
      PreparedStatement pst=con.prepareStatement("Select record__id from _siteresources where name=? and type=? and master__id=? and mastertype=?");
      pst.setString(1,resname);
      pst.setString(2,restype);
      pst.setLong(3,contid);
      pst.setString(4,conttype);
      ResultSet rs=pst.executeQuery();
      if (rs.next()) {
        return rs.getInt(1);
      } else {
        pst=con.prepareStatement("Insert into _siteresources set name=?,type=?,master__id=?,mastertype=?");
        pst.setString(1,resname);
        pst.setString(2,restype);
        pst.setLong(3,contid);
        pst.setString(4,conttype);
        pst.executeUpdate();
        return ((org.gjt.mm.mysql.PreparedStatement)pst).getLastInsertID();
      } 
    } catch (Exception e) {System.err.println(e.toString());return 0;}
  }

  public void setField(Connection con,webJinn.field.Field field) {
    try{
      PreparedStatement pst=con.prepareStatement("Update _siteresources set res_INFO=?,res=? where record__id=?");
      long resid=getResourceID(con);
      pst.setLong(3,resid);
      if (field==null) {
        pst.setNull(1,java.sql.Types.NULL);
        pst.setNull(2,java.sql.Types.NULL);
        try{pst.executeUpdate();}catch (Exception sqlexc) {}
      } else {
        InputStream in=null;
        try{
          if (restype.equals("img")) {
            webJinn.field.FileField ffield=(webJinn.field.FileField)field;
            if (ffield.isShouldBeRemoved()) {
              pst.setNull(1,java.sql.Types.NULL);
              pst.setNull(2,java.sql.Types.NULL);
            } else {
              if (!ffield.isExternal()) {
                in = new FileInputStream(ffield.getFile());
                pst.setString(1,ffield.getAttributes());
                pst.setBinaryStream(2,in,Integer.MAX_VALUE);
              }
            }
          } else {
            pst.setNull(2,java.sql.Types.NULL);
            webJinn.field.TextField tfield=(webJinn.field.TextField)field;
            pst.setString(1,tfield.getStringValue());
          }
          try{pst.executeUpdate();}catch (Exception sqlexc) {}
        } finally {if (in!=null) try{in.close();}catch (Exception ee) {}}
      }
    } catch (Exception e) {}
  }

  /*Properties*/
  public void setDescription(String val) {
    description=val;
  }
  public String getDescription() {
    return description;
  }

  public String getName() {
    return resname;
  }

  public String getType() {
    return restype;
  }

  public String getContType() {
    return conttype;
  }

  public long getContId() {
    return contid;
  }


}