package pattern.sitebuilder;
import webJinn.exception.*;
import java.io.*;
import javax.servlet.http.*;
import java.util.*;
import webJinn.field.*;
import webJinn.*;

public class EntityRequestParamsReader extends webJinn.EntityRequestParamsReader {

  protected boolean isInAllowedContentTypes(String fieldName,String contentType) {
    if (fieldName==null || contentType==null) return super.isInAllowedContentTypes(fieldName,contentType);
    if (contentType.equals("image/pjpeg") || contentType.equals("image/gif") || contentType.equals("image/jpg")  || contentType.equals("image/jpeg")) {
      return true;
    }
    return false;
  }

  protected int getAllowedFieldSize(String fieldName) {
    return Integer.MAX_VALUE;
  }
  
  protected TextField getTextField(String fieldName,String value,Hashtable result) {
    if (value==null || value.length()==0) return null;
    TextField tf=(TextField)result.get(fieldName);
    if (tf!=null) {tf.addValue(value);}
    else tf=new TextField(fieldName,value);
    return tf;
  }

  public EntityRequestParamsReader(UploadManager manager) {
    super(manager,null);
    necessaryGroupName=null;
  }

  public void setNecessaryGroup(String necessaryGroupName) {}

  public String getNecessaryGroup() {return necessaryGroupName;}

  protected void checkNecessaryFields() {}

  public void parseRequest(HttpServletRequest request) throws FormErrorException,IOException,SessionClosedException {
     errors.clear();
     params=null;
     groups=null;
     if (encoding==null) encoding=request.getCharacterEncoding();
     groupsDetected=false;
     formID=null;
     if (params==null) {
       String contentType=request.getContentType();
       if (contentType!=null && contentType.startsWith("multipart/form-data")) {
         if (manager!=null) {
          try{
           params=getMultiPartRequestParams(request);
          } catch (Exception e) {}
         }
       } else {
         params=getRequestParams(request);
       }
     }
  }
}

