package pattern.sitebuilder;
import java.io.*;

public abstract class ContainerPattern {
  protected String patternDir=null;

  protected void setPatternDir(String rootDir,String patternURI) {
   patternDir=rootDir+File.separator+patternURI.replace('/',File.separatorChar);
   if (patternDir.endsWith(File.separator)) patternDir=patternDir.substring(0,patternDir.length()-1);
  }

  protected boolean exists(String name) {
    File dir=new File(patternDir+File.separator+name);
    return dir.exists();
  }

  public String[] getPatterns() {
    File dir=new File(patternDir);
    class DirFilter implements FileFilter {
      public boolean accept(File pathname) {
        if (pathname.isDirectory()) return true; else return false;
      }
    }
    File[] files=dir.listFiles(new DirFilter());
    if (files==null) return new String[0];
    String[] result=new String[files.length];
    for (int i=0;i<files.length;i++)
      result[i]=files[i].getName();
    return result;
  }


  public boolean createNew(String name) {
   try{
    File dir=new File(patternDir+File.separator+name);
    if (dir.exists()) return false;
    if (!dir.mkdirs()) return false;
    makePatternFiles(name);
    return true;
   } catch (Exception e) {return false;}
  }

  public void delete(String name) {
    File dir=new File(patternDir+File.separator+name);
    deleteDir(dir);
  }

  protected void deleteDir(File dir) {
    try{
      File[] files=dir.listFiles();
      if (files!=null)
        for (int i=0;i<files.length;i++)
          if (files[i].isDirectory()) deleteDir(files[i]); else files[i].delete();
      dir.delete();
    } catch (Exception e) {}
  }

  protected void updateCode(File pattern,String newCode) {
    if (newCode==null) newCode="";
    try{
      BufferedWriter writer=new BufferedWriter(new OutputStreamWriter(new FileOutputStream(pattern),"Cp1251"));
      try{
        writer.write(newCode);
      } finally {writer.close();}
    } catch (Exception e) {}
  } 

  protected String getCode(File pattern) {
    StringBuffer result=new StringBuffer();
    try{
      BufferedReader reader=new BufferedReader(new InputStreamReader(new FileInputStream(pattern),"Cp1251"));
      try{
        String line;
        while ((line=reader.readLine())!=null) 
        result=result.append(line).append("\n");
      } finally {reader.close();}
    } catch (Exception e) {}
    return result.toString();
  }
  protected abstract void makePatternFiles(String name);
}