package org.webjinn.cms.model;

/** Represents Menu element of the interface tree */
public interface Menu 
	extends InterfaceTreeElement, AttributeContainer, CSSFilesContainer {
	
	/** Returns header string associated with the menu */
	public String getHeader();

	/** Returns footer string associated with the menu */
	public String getFooter();

	/** Sets new header into the Menu */
	public void setHeader(String header);
	
	/** Sets new footer into the Menu */
	public void setFooter(String footer);

  /** Returns associated (parent) Item element 
	 * (or null if it is the root menu) */
  public Item getParentItem();

  /** Returns nested Item elements */
  public Item[] getChildItems(); 	
	
}
