package org.webjinn.cms.model;

/** Provides access to the CMS tree */
public interface CMSTree {

  /** Retrieves array of interfaces */	
	public Interface[] getInterfaces();

	/** Retrieves array of pages */
	public Page[] getPages();	

	/** Adds new interface to the tree */
	public void addInterface(Interface in);

  /** Removes an interface from the tree */
	public void removeInterface(Interface in);

  /** Adds new page information to the tree */
  public void addPage(Page page);

  /** Removes a page from the tree */
	public void removePage(Page page);
	
  /** Tests if uri given corresponds to a tree page */
	public boolean isTreePage(String uri);

  /** Associates a Menu with the Item element 
	 * (adds the Menu element as a child of the Item element) */
  public void addMenu(Menu menu, Item item); 	

	/** Adds given Item element as a child of the Menu element */
	public void addItem(Menu menu, Item item);

	/** Moves an Item element one position up or down 
	 * within the associated Menu */
	public void moveItem(Item item, boolean up);

	/** Wraps the page according to the state of the
	 * tree */
	public void wrap(Page page);
	
	/** Synchronizes CMS tree with actual site content (files) */
	public void synchronize();

}
