package org.webjinn.cms.model;

/** Represents container that is 
 * able to store attributes */
public interface AttributeContainer {

	/** Retrieves a list of attributes stored in the container */
	public Attribute[] getAttributes();

	/** Adds an attribute to the container */
	public void addAttribute(Attribute attr);

	/** Removes an attribute from the container */
	public void removeAttribute(Attribute attr);

  /** Retrieves only attributes used within the code
	 * associated with the container */
	public Attribute[] getCodeAttributes();
	
}
