package org.webjinn.cms.model;

/** Represents container that is 
 * able to store css files collection */
public interface CSSFilesContainer {

	/** Retrieves a list of attributes stored in the container */
	public CSSFile[] getCSSFiles();

	/** Creates CSS file using url provided and 
	 * places it in the container */
	public void addCSSFile(String url);

	/** Removes a CSSFile from the container.
	 * Does nothing if argument CSSFile is not found
	 * in the container */
	public void removeCSSFile(CSSFile cssfile);

}
