package org.webjinn.cms.model;

/** Provides access to the CMS tree */
public interface CMSTree {

  /** Retrieves array of interfaces */	
	public Interface[] getInterfaces();

	/** Retrieves Interface by name */
	public Interface getInterface(String name);

	/** Adds a new interface to the tree.
	 * Interface name provide must be not null, not empty and
	 * unique among interfaces already in the tree */
	public void addInterface(String name, String descr);

  /** Removes an interface from the tree. 
	 * Do nothing if Interface object provided is not
	 * found in the tree */
	public void removeInterface(Interface in);

	/** Given an interface-uri string returns corresponding tree element 
	 * or null if not found */
	public InterfaceTreeElement resolveInterfaceURI(String uri);

	/** Retrieves array of pages */
	public Page[] getPages();	

	/** Returns Page object by file URI */
	public Page getPage(String fileURI);

  /** Adds new page information to the tree. */
  public void addPage(String fileURI, String menuURI);

  /** Removes a page from the tree. Do nothing if
	 * this page object is not found in the tree */
	public void removePage(Page page);

}
