/*
 * Decompiled with CFR 0.152.
 */
package org.webjinn.cms.model.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.webjinn.cms.model.Attribute;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.CSSFile;
import org.webjinn.cms.model.InterfaceTreeElement;
import org.webjinn.cms.model.Page;
import org.webjinn.cms.model.weaver.TextProcessingUtils;
import org.webjinn.cms.model.xml.Utils;
import org.webjinn.cms.model.xml.XMLAttributeImpl;
import org.webjinn.cms.model.xml.XMLCMSTree;
import org.webjinn.cms.model.xml.XMLCSSFileImpl;

public class XMLPageImpl
implements Page {
    private Element el;
    private XMLCMSTree tree;
    private Node attributesNode;
    private Node cssfilesNode;

    public XMLPageImpl(Element element, XMLCMSTree xMLCMSTree) {
        this.el = element;
        this.tree = xMLCMSTree;
        this.attributesNode = Utils.getChildNodeByName(element, "attributes");
        this.cssfilesNode = Utils.getChildNodeByName(element, "cssfiles");
    }

    public String getFileURI() {
        return this.el.getAttribute("file-uri");
    }

    private String getAbsoluteFilePath() {
        String string = this.tree.getRootDir();
        if ((string = new File(string).getAbsolutePath()).endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = this.getFileURI();
        string2 = string2.replace('/', File.separatorChar);
        return string + File.separator + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPageContent() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getAbsoluteFilePath();
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "Cp1251"));
            try {
                String string2;
                boolean bl = true;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.indexOf("<!-- Generated Start -->") >= 0) {
                        bl = false;
                        continue;
                    }
                    if (string2.indexOf("<!-- Generated End -->") >= 0) {
                        bl = true;
                        continue;
                    }
                    if (!bl && string2.indexOf("<!-- HEADER -->") < 0 && string2.indexOf("<!-- FOOTER -->") < 0) continue;
                    stringBuffer = stringBuffer.append(string2).append("\n");
                }
            }
            finally {
                bufferedReader.close();
            }
            int n = stringBuffer.length();
            if (n > 0) {
                return stringBuffer.substring(0, n - 1);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageContent(String string) {
        try {
            String string2;
            File file;
            if (string == null) {
                string = "";
            }
            if (!(file = new File(string2 = this.getAbsoluteFilePath())).exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "Cp1251"));
            try {
                bufferedWriter.write(string);
            }
            finally {
                bufferedWriter.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void wrap() {
        this.setPageContent(TextProcessingUtils.wrap(this));
    }

    public InterfaceTreeElement getAssociatedElement() {
        return this.tree.resolveInterfaceURI(this.el.getAttribute("interface-uri"));
    }

    public CMSTree getCMSTree() {
        return this.tree;
    }

    public CSSFile[] getCSSFiles() {
        List list = Utils.getChildNodesByName(this.cssfilesNode, "cssfile");
        int n = list.size();
        CSSFile[] cSSFileArray = new CSSFile[n];
        for (int i = 0; i < n; ++i) {
            cSSFileArray[i] = new XMLCSSFileImpl((Element)list.get(i), this);
        }
        return cSSFileArray;
    }

    public CSSFile getCSSFile(String string) {
        if (string == null) {
            return null;
        }
        List list = Utils.getChildNodesByName(this.cssfilesNode, "cssfile");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)list.get(i);
            String string2 = element.getAttribute("url");
            if (string2 == null || !string2.equals(string)) continue;
            return new XMLCSSFileImpl(element, this);
        }
        return null;
    }

    public void addCSSFile(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        Element element = XMLCSSFileImpl.createCSSFile(this.el.getOwnerDocument(), string);
        this.cssfilesNode.appendChild(element);
        this.tree.updateFile();
    }

    public void removeCSSFile(CSSFile cSSFile) {
        if (cSSFile instanceof XMLCSSFileImpl) {
            Element element = ((XMLCSSFileImpl)cSSFile).getXMLElement();
            this.cssfilesNode.removeChild(element);
            this.tree.updateFile();
        }
    }

    public Attribute[] getAttributes() {
        List list = Utils.getChildNodesByName(this.attributesNode, "attribute");
        int n = list.size();
        Attribute[] attributeArray = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            attributeArray[i] = new XMLAttributeImpl((Element)list.get(i), this);
        }
        return attributeArray;
    }

    public Attribute getAttribute(String string) {
        List list = Utils.getChildNodesByName(this.attributesNode, "attribute");
        for (int i = 0; i < list.size(); ++i) {
            if (!((Element)list.get(i)).getAttribute("name").equals(string)) continue;
            return new XMLAttributeImpl((Element)list.get(i), this);
        }
        return null;
    }

    public void addAttribute(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return;
        }
        Attribute attribute = this.getAttribute(string);
        if (attribute != null) {
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            attribute.setDescription(string2);
            attribute.setValue(string3);
        } else {
            Element element = XMLAttributeImpl.createAttribute(this.el.getOwnerDocument(), string, string2, string3);
            this.attributesNode.appendChild(element);
        }
        this.tree.updateFile();
    }

    public void removeAttribute(Attribute attribute) {
        if (attribute instanceof XMLAttributeImpl) {
            Element element = ((XMLAttributeImpl)attribute).getXMLElement();
            this.attributesNode.removeChild(element);
            this.tree.updateFile();
        }
    }

    protected Element getXMLElement() {
        return this.el;
    }

    protected static Element createPage(Document document, String string, String string2) {
        Element element = Utils.createElementNode(document, "page");
        element.setAttribute("file-uri", string);
        element.setAttribute("interface-uri", string2);
        Element element2 = Utils.createElementNode(document, "attributes");
        Element element3 = Utils.createElementNode(document, "cssfiles");
        element.appendChild(element2);
        element.appendChild(element3);
        return element;
    }
}

