/*
 * Decompiled with CFR 0.152.
 */
package org.webjinn.cms.model.xml;

import dom.Writer;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Interface;
import org.webjinn.cms.model.InterfaceTreeElement;
import org.webjinn.cms.model.Item;
import org.webjinn.cms.model.Menu;
import org.webjinn.cms.model.Page;
import org.webjinn.cms.model.xml.Utils;
import org.webjinn.cms.model.xml.XMLInterfaceImpl;
import org.webjinn.cms.model.xml.XMLPageImpl;

public class XMLCMSTree
implements CMSTree {
    private String fileURI;
    private Document doc;
    private Writer writer;
    private Node rootNode;
    private Node interfacesNode;
    private Node pagesNode;
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";

    public XMLCMSTree(String string) {
        this.fileURI = string;
        this.doc = this.getDOMTree();
        this.rootNode = this.doc.getDocumentElement();
        this.interfacesNode = Utils.getChildNodeByName(this.rootNode, "interfaces");
        this.pagesNode = Utils.getChildNodeByName(this.rootNode, "pages");
        this.writer = new Writer();
    }

    public Interface[] getInterfaces() {
        List list = this.getInterfaceNodes();
        int n = list.size();
        Interface[] interfaceArray = new Interface[n];
        for (int i = 0; i < n; ++i) {
            interfaceArray[i] = new XMLInterfaceImpl((Element)list.get(i), this);
        }
        return interfaceArray;
    }

    public Interface getInterface(String string) {
        List list = this.getInterfaceNodes();
        for (int i = 0; i < list.size(); ++i) {
            if (!((Element)list.get(i)).getAttribute("name").equals(string)) continue;
            return new XMLInterfaceImpl((Element)list.get(i), this);
        }
        return null;
    }

    public void addInterface(String string, String string2) {
        if (string == null || string.length() == 0 || this.getInterface(string) != null) {
            return;
        }
        Element element = XMLInterfaceImpl.createInterface(this.doc, string, string2);
        this.interfacesNode.appendChild(element);
        this.updateFile();
    }

    public void removeInterface(Interface interface_) {
        if (interface_ instanceof XMLInterfaceImpl) {
            Element element = ((XMLInterfaceImpl)interface_).getXMLElement();
            this.updatePagesOnRemove(interface_.getRootMenu());
            this.interfacesNode.removeChild(element);
            this.updateFile();
        }
    }

    public InterfaceTreeElement resolveInterfaceURI(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            Interface interface_ = this.getInterface(stringTokenizer.nextToken());
            Menu menu = interface_.getRootMenu();
            String string2 = stringTokenizer.nextToken();
            String string3 = this.getMenuName(string2);
            if (string3 == null) {
                return null;
            }
            String string4 = this.getItemName(string2);
            if (!menu.getName().equals(string3)) {
                return null;
            }
            if (stringTokenizer.hasMoreTokens()) {
                if (string4 != null) {
                    return null;
                }
            } else {
                if (string4 == null) {
                    return menu;
                }
                return menu.getChildItem(string4);
            }
            InterfaceTreeElement interfaceTreeElement = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                interfaceTreeElement = this.getTreeElement(menu, string2);
                if (interfaceTreeElement == null) {
                    return null;
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                if (interfaceTreeElement instanceof Menu) {
                    menu = (Menu)interfaceTreeElement;
                    continue;
                }
                return null;
            }
            return interfaceTreeElement;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Page[] getPages() {
        List list = this.getPageNodes();
        int n = list.size();
        Page[] pageArray = new Page[n];
        for (int i = 0; i < n; ++i) {
            pageArray[i] = new XMLPageImpl((Element)list.get(i), this);
        }
        return pageArray;
    }

    public Page getPage(String string) {
        List list = this.getPageNodes();
        for (int i = 0; i < list.size(); ++i) {
            if (!((Element)list.get(i)).getAttribute("file-uri").equals(string)) continue;
            return new XMLPageImpl((Element)list.get(i), this);
        }
        return null;
    }

    public Page[] getAssociatedPages(String string) {
        if (string == null || string.length() == 0) {
            return this.getPages();
        }
        List list = this.getPageNodes();
        Vector<XMLPageImpl> vector = new Vector<XMLPageImpl>();
        for (int i = 0; i < list.size(); ++i) {
            if (!((Element)list.get(i)).getAttribute("interface-uri").equals(string)) continue;
            vector.add(new XMLPageImpl((Element)list.get(i), this));
        }
        return vector.toArray(new Page[0]);
    }

    public Page[] getRelatedPages(String string) {
        System.err.println("Related for interfaceURI=" + string);
        if (string == null || string.length() == 0) {
            return this.getPages();
        }
        List list = this.getPageNodes();
        Vector<XMLPageImpl> vector = new Vector<XMLPageImpl>();
        for (int i = 0; i < list.size(); ++i) {
            if (!((Element)list.get(i)).getAttribute("interface-uri").startsWith(string)) continue;
            vector.add(new XMLPageImpl((Element)list.get(i), this));
        }
        return vector.toArray(new Page[0]);
    }

    public Page[] getDirectoryPages(String string, boolean bl) {
        if (string == null) {
            return new Page[0];
        }
        string.replace(File.separatorChar, '/');
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        List list = this.getPageNodes();
        Vector<XMLPageImpl> vector = new Vector<XMLPageImpl>();
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            String string2 = element.getAttribute("file-uri");
            if (bl) {
                if (!string2.startsWith(string)) continue;
                vector.add(new XMLPageImpl(element, this));
                continue;
            }
            int n = string2.lastIndexOf(47);
            String string3 = n <= 0 ? "" : string2.substring(0, n);
            if (!string3.equals(string)) continue;
            vector.add(new XMLPageImpl(element, this));
        }
        return vector.toArray(new Page[0]);
    }

    public void addPage(String string, String string2) {
        if (string == null || string2 == null || this.getPage(string) != null || this.resolveInterfaceURI(string2) == null) {
            return;
        }
        Element element = XMLPageImpl.createPage(this.doc, string, string2);
        this.pagesNode.appendChild(element);
        this.updateFile();
    }

    public void removePage(Page page) {
        if (page == null) {
            return;
        }
        if (page instanceof XMLPageImpl) {
            this.removePage((XMLPageImpl)page);
            this.updateFile();
        }
    }

    public void removePages(Page[] pageArray) {
        if (pageArray == null) {
            return;
        }
        for (int i = 0; i < pageArray.length; ++i) {
            if (!(pageArray[i] instanceof XMLPageImpl)) continue;
            this.removePage((XMLPageImpl)pageArray[i]);
        }
        this.updateFile();
    }

    public String getRootDir() {
        return ((Element)this.rootNode).getAttribute("rootdir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFile() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this.fileURI));
            try {
                this.writer.setOutput(fileOutputStream, null);
                this.writer.write(this.doc);
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void updatePagesOnRemove(InterfaceTreeElement interfaceTreeElement) {
        Page[] pageArray = this.getRelatedPages(interfaceTreeElement.getInterfaceURI());
        System.err.println("pages=" + pageArray);
        System.err.println("pages.length=" + pageArray.length);
        for (int i = 0; i < pageArray.length; ++i) {
            if (!(pageArray[i] instanceof XMLPageImpl)) continue;
            pageArray[i].setPageContent(pageArray[i].getPageContent());
            Element element = ((XMLPageImpl)pageArray[i]).getXMLElement();
            this.pagesNode.removeChild(element);
        }
    }

    private void removePage(XMLPageImpl xMLPageImpl) {
        if (xMLPageImpl == null) {
            return;
        }
        try {
            xMLPageImpl.setPageContent(xMLPageImpl.getPageContent());
            Element element = xMLPageImpl.getXMLElement();
            this.pagesNode.removeChild(element);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List getInterfaceNodes() {
        return Utils.getChildNodesByName(this.interfacesNode, "interface");
    }

    private List getPageNodes() {
        return Utils.getChildNodesByName(this.pagesNode, "page");
    }

    private Document getDOMTree() {
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(this.fileURI);
            return dOMParser.getDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String getMenuName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        if (n == 0 || n == string.length() - 1) {
            return null;
        }
        if (n < 0) {
            return string;
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    private String getItemName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        if (n <= 0 || n == string.length() - 1) {
            return null;
        }
        if (n > 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    private InterfaceTreeElement getTreeElement(Menu menu, String string) {
        String string2 = this.getMenuName(string);
        String string3 = this.getItemName(string);
        if (string2 == null) {
            return null;
        }
        Item[] itemArray = menu.getChildItems();
        for (int i = 0; i < itemArray.length; ++i) {
            Menu menu2 = itemArray[i].getChildMenu();
            if (menu2 == null || !menu2.getName().equals(string2)) continue;
            if (string3 == null) {
                return menu2;
            }
            return menu2.getChildItem(string3);
        }
        return null;
    }
}

