/*
 * Decompiled with CFR 0.152.
 */
package org.webjinn.cms.model.weaver;

import java.util.HashSet;
import java.util.Vector;
import org.webjinn.cms.model.Attribute;
import org.webjinn.cms.model.AttributeContainer;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.CSSFile;
import org.webjinn.cms.model.CSSFilesContainer;
import org.webjinn.cms.model.InterfaceTreeElement;
import org.webjinn.cms.model.Item;
import org.webjinn.cms.model.Menu;
import org.webjinn.cms.model.Page;
import org.webjinn.cms.model.weaver.AttributeTag;
import org.webjinn.utils.Parser;

public class TextProcessingUtils {
    public static AttributeTag[] getAttributes(String string, String string2) {
        if (string == null || string2 == null) {
            return new AttributeTag[0];
        }
        Vector<AttributeTag> vector = new Vector<AttributeTag>();
        String[] stringArray = new String[]{string2};
        boolean[] blArray = new boolean[]{false};
        Parser parser = new Parser(string, stringArray, blArray);
        parser.parse();
        Parser.Element[] elementArray = parser.getElements();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < elementArray.length; ++i) {
            String string3;
            if (!string2.equalsIgnoreCase(elementArray[i].getType()) || hashSet.contains(string3 = elementArray[i].getAttribute("name"))) continue;
            AttributeTag attributeTag = new AttributeTag(string2);
            attributeTag.setName(string3);
            attributeTag.setHTMLType(elementArray[i].getAttribute("htmltype"));
            attributeTag.setDescription(elementArray[i].getAttribute("description"));
            vector.add(attributeTag);
            hashSet.add(string3);
        }
        return vector.toArray(new AttributeTag[0]);
    }

    public static String buildMenuPart(String string, Page page, Menu menu, Item item) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = new String[]{"cms:cssfiles", "cms:menuattribute", "cms:pageattribute", "cms:selecteditem", "cms:noselecteditem", "cms:menuitems"};
            boolean bl = item != null;
            boolean[] blArray = new boolean[]{false, false, false, true, true, true};
            Parser parser = new Parser(string, stringArray, blArray);
            parser.parse();
            Parser.Element[] elementArray = parser.getElements();
            for (int i = 0; i < elementArray.length; ++i) {
                TextProcessingUtils.parseElement(elementArray[i], page, menu, item, bl, stringBuffer);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String wrap(Page page) {
        String string = TextProcessingUtils.buildPagePart(page, true);
        String string2 = TextProcessingUtils.buildPagePart(page, false);
        String string3 = page.getPageContent();
        int n = string3.indexOf("<!-- HEADER -->");
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= 0) {
            stringBuffer.append(string3.substring(0, n) + "\n");
            stringBuffer.append("<!-- Generated Start -->\n");
            stringBuffer.append("<!-- HEADER -->\n");
            stringBuffer.append(string + "\n");
            stringBuffer.append("<!-- Generated End -->\n");
            string3 = string3.substring(n + "<!-- HEADER -->".length());
        } else {
            stringBuffer.append("<!-- Generated Start -->\n");
            stringBuffer.append(string + "\n");
            stringBuffer.append("<!-- Generated End -->\n");
        }
        int n2 = string3.indexOf("<!-- FOOTER -->");
        if (n2 >= 0) {
            stringBuffer.append(string3.substring(0, n2) + "\n");
            stringBuffer.append("<!-- Generated Start -->\n");
            stringBuffer.append("<!-- FOOTER -->\n");
            stringBuffer.append(string2 + "\n");
            stringBuffer.append("<!-- Generated End -->\n");
            stringBuffer.append(string3.substring(n2 + "<!-- FOOTER -->".length()));
        } else {
            stringBuffer.append(string3 + "\n");
            stringBuffer.append("<!-- Generated Start -->\n");
            stringBuffer.append(string2 + "\n");
            stringBuffer.append("<!-- Generated End -->");
        }
        return stringBuffer.toString();
    }

    public static String buildPagePart(Page page, boolean bl) {
        CMSTree cMSTree = page.getCMSTree();
        InterfaceTreeElement interfaceTreeElement = page.getAssociatedElement();
        Menu menu = null;
        Item item = null;
        if (interfaceTreeElement instanceof Menu) {
            menu = (Menu)interfaceTreeElement;
        } else {
            item = (Item)interfaceTreeElement;
            menu = item.getParentMenu();
        }
        String string = "";
        string = bl ? TextProcessingUtils.buildHeader(page, menu, item) : TextProcessingUtils.buildFooter(page, menu, item);
        return string;
    }

    public static CSSFile[] getCSSFiles(Page page) {
        Vector vector = new Vector();
        TextProcessingUtils.addCSSFiles(page, vector);
        InterfaceTreeElement interfaceTreeElement = page.getAssociatedElement();
        Menu menu = null;
        menu = interfaceTreeElement instanceof Menu ? (Menu)interfaceTreeElement : ((Item)interfaceTreeElement).getParentMenu();
        while (menu != null) {
            TextProcessingUtils.addCSSFiles(menu, vector);
            Item item = menu.getParentItem();
            if (item == null) {
                menu = null;
                continue;
            }
            menu = item.getParentMenu();
        }
        return vector.toArray(new CSSFile[0]);
    }

    private static void addCSSFiles(CSSFilesContainer cSSFilesContainer, Vector vector) {
        CSSFile[] cSSFileArray = cSSFilesContainer.getCSSFiles();
        if (cSSFileArray == null) {
            return;
        }
        for (int i = 0; i < cSSFileArray.length; ++i) {
            vector.add(cSSFileArray[i]);
        }
    }

    private static String buildHeader(Page page, Menu menu, Item item) {
        Item item2 = menu.getParentItem();
        if (item2 == null) {
            return TextProcessingUtils.buildMenuPart(menu.getHeader(), page, menu, item);
        }
        Menu menu2 = item2.getParentMenu();
        String string = TextProcessingUtils.buildHeader(page, menu2, item2);
        int n = TextProcessingUtils.getChildNum(menu2, item2);
        String[] stringArray = new String[]{"cms:submenu"};
        boolean[] blArray = new boolean[]{false};
        Parser parser = new Parser(string, stringArray, blArray);
        StringBuffer stringBuffer = new StringBuffer();
        parser.parse();
        Parser.Element[] elementArray = parser.getElements();
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < elementArray.length; ++i) {
            if (elementArray[i].getType().equalsIgnoreCase("text")) {
                stringBuffer.append(elementArray[i].getBody());
            }
            if (!elementArray[i].getType().equalsIgnoreCase("cms:submenu") || ++n2 != n) continue;
            stringBuffer.append(TextProcessingUtils.buildMenuPart(menu.getHeader(), page, menu, item));
            bl = true;
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return string + TextProcessingUtils.buildMenuPart(menu.getHeader(), page, menu, item);
    }

    private static int getChildNum(Menu menu, Item item) {
        String string = item.getName();
        int n = 0;
        Item[] itemArray = menu.getChildItems();
        for (int i = 0; i < itemArray.length; ++i) {
            ++n;
            if (!itemArray[i].getName().equals(string)) continue;
            return n;
        }
        return -1;
    }

    private static String buildFooter(Page page, Menu menu, Item item) {
        Item item2 = menu.getParentItem();
        if (item2 == null) {
            return TextProcessingUtils.buildMenuPart(menu.getFooter(), page, menu, item);
        }
        Menu menu2 = item2.getParentMenu();
        return TextProcessingUtils.buildMenuPart(menu.getFooter(), page, menu, item) + TextProcessingUtils.buildFooter(page, menu2, item2);
    }

    private static void parseElement(Parser.Element element, Page page, Menu menu, Item item, boolean bl, StringBuffer stringBuffer) {
        Parser.Element[] elementArray;
        boolean[] blArray;
        String[] stringArray;
        if (element == null) {
            return;
        }
        String string = element.getType();
        if (string.equalsIgnoreCase("text")) {
            stringBuffer.append(element.getBody());
            return;
        }
        if (string.equalsIgnoreCase("cms:itemattribute")) {
            if (menu != null) {
                stringBuffer.append(TextProcessingUtils.getAttributeValue(element, item));
            }
            return;
        }
        if (string.equalsIgnoreCase("cms:menuattribute")) {
            if (item != null) {
                stringBuffer.append(TextProcessingUtils.getAttributeValue(element, menu));
            }
            return;
        }
        if (string.equalsIgnoreCase("cms:pageattribute")) {
            if (page != null) {
                stringBuffer.append(TextProcessingUtils.getAttributeValue(element, page));
            }
            return;
        }
        if (string.equalsIgnoreCase("cms:cssfiles")) {
            if (page == null) {
                return;
            }
            CSSFile[] cSSFileArray = TextProcessingUtils.getCSSFiles(page);
            for (int i = 0; i < cSSFileArray.length; ++i) {
                String string2 = "<LINK href='" + cSSFileArray[i].getURL() + "' rel=STYLESHEET type=text/css>\n";
                stringBuffer.append(string2);
            }
            return;
        }
        if (string.equalsIgnoreCase("cms:inactiveitem") && !bl || string.equalsIgnoreCase("cms:selecteditem") && bl || string.equalsIgnoreCase("cms:noselecteditem") && !bl) {
            stringArray = new String[]{"cms:menuattribute", "cms:itemattribute", "cms:pageattribute", "cms:cssfiles"};
            blArray = new boolean[]{false, false, false, false};
            element.parseBody(stringArray, blArray);
            elementArray = element.getChildren();
            for (int i = 0; i < elementArray.length; ++i) {
                TextProcessingUtils.parseElement(elementArray[i], page, menu, item, bl, stringBuffer);
            }
        }
        if (string.equalsIgnoreCase("cms:menuitems")) {
            if (menu == null) {
                return;
            }
            stringArray = new String[]{"cms:menuattribute", "cms:pageattribute", "cms:itemattribute", "cms:selecteditem", "cms:inactiveitem"};
            blArray = new boolean[]{false, false, false, true, true};
            element.parseBody(stringArray, blArray);
            elementArray = element.getChildren();
            Item[] itemArray = menu.getChildItems();
            for (int i = 0; i < itemArray.length; ++i) {
                boolean bl2 = item != null && itemArray[i] != null && item.getName().equals(itemArray[i].getName());
                for (int j = 0; j < elementArray.length; ++j) {
                    TextProcessingUtils.parseElement(elementArray[j], page, menu, itemArray[i], bl2, stringBuffer);
                }
            }
            return;
        }
    }

    private static String getAttributeValue(Parser.Element element, AttributeContainer attributeContainer) {
        String string = element.getAttribute("name");
        Attribute attribute = attributeContainer.getAttribute(string);
        if (attribute == null) {
            return "";
        }
        return attribute.getValue();
    }
}

