/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.ParserWrapper;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Writer {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected boolean fXML11;

    public Writer() {
    }

    public Writer(boolean bl) {
        this.fCanonical = bl;
    }

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(java.io.Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void write(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                Document document = (Document)node;
                this.fXML11 = "1.1".equals(this.getVersion(document));
                if (!this.fCanonical) {
                    if (this.fXML11) {
                        this.fOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                    } else {
                        this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    }
                    this.fOut.flush();
                    this.write(document.getDoctype());
                }
                this.write(document.getDocumentElement());
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                this.fOut.print("<!DOCTYPE ");
                this.fOut.print(documentType.getName());
                String string = documentType.getPublicId();
                String string2 = documentType.getSystemId();
                if (string != null) {
                    this.fOut.print(" PUBLIC '");
                    this.fOut.print(string);
                    this.fOut.print("' '");
                    this.fOut.print(string2);
                    this.fOut.print('\'');
                } else if (string2 != null) {
                    this.fOut.print(" SYSTEM '");
                    this.fOut.print(string2);
                    this.fOut.print('\'');
                }
                String string3 = documentType.getInternalSubset();
                if (string3 != null) {
                    this.fOut.println(" [");
                    this.fOut.print(string3);
                    this.fOut.print(']');
                }
                this.fOut.println('>');
                break;
            }
            case 1: {
                this.fOut.print('<');
                this.fOut.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    this.fOut.print(' ');
                    this.fOut.print(attr.getNodeName());
                    this.fOut.print("=\"");
                    this.normalizeAndPrint(attr.getNodeValue(), true);
                    this.fOut.print('\"');
                }
                this.fOut.print('>');
                this.fOut.flush();
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.write(node2);
                }
                break;
            }
            case 5: {
                if (this.fCanonical) {
                    for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                        this.write(node3);
                    }
                    break;
                }
                this.fOut.print('&');
                this.fOut.print(node.getNodeName());
                this.fOut.print(';');
                this.fOut.flush();
                break;
            }
            case 4: {
                if (this.fCanonical) {
                    this.normalizeAndPrint(node.getNodeValue(), false);
                } else {
                    this.fOut.print("<![CDATA[");
                    this.fOut.print(node.getNodeValue());
                    this.fOut.print("]]>");
                }
                this.fOut.flush();
                break;
            }
            case 3: {
                this.normalizeAndPrint(node.getNodeValue(), false);
                this.fOut.flush();
                break;
            }
            case 7: {
                this.fOut.print("<?");
                this.fOut.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.fOut.print(' ');
                    this.fOut.print(string);
                }
                this.fOut.print("?>");
                this.fOut.flush();
                break;
            }
            case 8: {
                if (this.fCanonical) break;
                this.fOut.print("<!--");
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.fOut.print(string);
                }
                this.fOut.print("-->");
                this.fOut.flush();
            }
        }
        if (s == 1) {
            this.fOut.print("</");
            this.fOut.print(node.getNodeName());
            this.fOut.print('>');
            this.fOut.flush();
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    protected void normalizeAndPrint(String string, boolean bl) {
        int n = string != null ? string.length() : 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.normalizeAndPrint(c, bl);
        }
    }

    protected void normalizeAndPrint(char c, boolean bl) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (bl) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || bl && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected String getVersion(Document document) {
        if (document == null) {
            return null;
        }
        String string = null;
        Method method = null;
        try {
            method = document.getClass().getMethod("getXmlVersion", new Class[0]);
            if (method != null) {
                string = (String)method.invoke((Object)document, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        Writer writer = null;
        ParserWrapper parserWrapper = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            String string = stringArray[i];
            if (string.startsWith("-")) {
                object2 = string.substring(1);
                if (((String)object2).equals("p")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    object = stringArray[i];
                    try {
                        parserWrapper = (ParserWrapper)Class.forName((String)object).newInstance();
                    }
                    catch (Exception exception) {
                        parserWrapper = null;
                        System.err.println("error: Unable to instantiate parser (" + (String)object + ")");
                    }
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("n")) {
                    bl = ((String)object2).equals("n");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("v")) {
                    bl2 = ((String)object2).equals("v");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("s")) {
                    bl3 = ((String)object2).equals("s");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("f")) {
                    bl4 = ((String)object2).equals("f");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("c")) {
                    bl5 = ((String)object2).equals("c");
                    continue;
                }
                if (((String)object2).equals("h")) {
                    Writer.printUsage();
                    continue;
                }
            }
            if (parserWrapper == null) {
                try {
                    parserWrapper = (ParserWrapper)Class.forName(DEFAULT_PARSER_NAME).newInstance();
                }
                catch (Exception exception) {
                    System.err.println("error: Unable to instantiate parser (dom.wrappers.Xerces)");
                    continue;
                }
            }
            try {
                parserWrapper.setFeature(NAMESPACES_FEATURE_ID, bl);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
            }
            try {
                parserWrapper.setFeature(VALIDATION_FEATURE_ID, bl2);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
            }
            try {
                parserWrapper.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl3);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
            }
            try {
                parserWrapper.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl4);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            if (writer == null) {
                writer = new Writer();
                try {
                    writer.setOutput(System.out, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.err.println("error: Unable to set output. Exiting.");
                    System.exit(1);
                }
            }
            writer.setCanonical(bl5);
            try {
                object2 = parserWrapper.parse(string);
                System.err.println("document=" + object2);
                System.err.println("document.root=" + object2.getDocumentElement());
                writer.write((Node)object2);
                continue;
            }
            catch (SAXParseException sAXParseException) {
                continue;
            }
            catch (Exception exception) {
                System.err.println("error: Parse error occurred - " + exception.getMessage());
                if (exception instanceof SAXException && (object = ((SAXException)exception).getException()) != null) {
                    object2 = object;
                }
                ((Throwable)object2).printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Select parser by name.");
        System.err.println("  -n | -N  Turn on/off namespace processing.");
        System.err.println("  -v | -V  Turn on/off validation.");
        System.err.println("  -s | -S  Turn on/off Schema validation support.");
        System.err.println("           NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F Turn on/off Schema full checking.");
        System.err.println("           NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -c | -C  Turn on/off Canonical XML output.");
        System.err.println("           NOTE: This is not W3C canonical output.");
        System.err.println("  -h       This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     dom.wrappers.Xerces");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Canonical:  ");
        System.err.println("off");
    }
}

