package peterson;
import java.util.*;
import java.io.*;
import pwbuilder.core.*;

/** TRM State Machine */
public class TRMStateMachine implements StateMachine {
    //Component system
    private SystemDescr system;
    //Component object
    private TextResourceManager trm;
    //Identificator of the component that is described by this state machine 
    private int cid;
    /** Variables that represent promela's global fields */
    private  String arrTypeName, rowsName, colsName, CName, TName, NName;

    /** TW cid to its C,T,N, and columns index mapping */
    private int[] twCids;

	public TRMStateMachine(SystemDescr system, TextResourceManager trm) {
      this.system=system;
      this.trm=trm; 
      ComponentDescr trmCD = system.getComponent(trm);
      this.cid = trmCD.getId();
      ConnectionDescr[] cons = system.getConnections();
      Vector twCons = new Vector();
      for (int i=0;i<cons.length;i++) 
        if (cons[i].getSourceComponent().getId()==cid) twCons.add(cons[i]);
      int len = twCons.size();
      twCids = new int[len];
      for (int i=0;i<len;i++) {
        ConnectionDescr con = (ConnectionDescr)twCons.get(i);
        twCids[i]=con.getTargetComponent().getId();
      }
      initVars();
    }

    private void initVars() {
      arrTypeName = "Array_"+cid;
      rowsName = "row_"+cid;
      colsName = "column_"+cid;
      CName = "C_"+cid;
      TName = "T_"+cid;
      NName = "N_"+cid;
    }

    /** @@see pwbuilder.core.StateMachine */
    public String generateGlobalVars() {
      int len = twCids.length;
      String arrSize = "["+len+"]";
      String fields =
        "\n /** Global Declarations of the TextResourceManager_"+cid+" component */ \n"+ 
        "typedef "+arrTypeName+"{ bool "+rowsName+arrSize+" = true};\n"+
        arrTypeName+" "+colsName+arrSize+";\n"+
        "bool "+CName+arrSize+" = false; "+
        "bool "+TName+arrSize+" = false; "+
        "bool "+NName+arrSize+" = true; \n";

      String inlineEventAction = 
        " inline TWEventAction_"+cid+"(pos, req) {\n"+
        "   if\n"+
        "     :: (req==true) ->\n"+
        "       atomic {\n"+
        "         assert("+NName+"[pos] && !"+CName+"[pos] && !"+TName+"[pos]);\n"+
        "         "+NName+"[pos] = false; "+TName+"[pos] = true;\n"+
        "         byte ind="+len+";\n"+
        "         do\n"+
        "           :: (ind==0) -> break;\n"+
        "           :: else -> \n"+
        "             ind=ind-1;\n"+
        "             if\n"+
        "               :: (pos!=ind && "+TName+"[ind]) -> "+colsName+"[pos]."+rowsName+"[ind] = false;\n"+
        "               :: else -> skip;\n"+
        "             fi;\n"+
        "          od;\n"+
        "       }\n"+
        "     :: else -> atomic {\n"+
        "       assert("+CName+"[pos] && !"+NName+"[pos] && !"+TName+"[pos]);\n"+
        "       "+CName+"[pos] = false; "+NName+"[pos] = true;\n"+
        "     }\n"+
        "   fi;\n"+
        " } \n";

      String inlineReceiveTWEvent = 
        " inline receiveTWEvent_"+cid+"(event) { \n"+
        generateCidToPosMapping()+"\n"+
        " }\n";

      return fields + "\n\n" + inlineEventAction + "\n\n"+inlineReceiveTWEvent;
    }

    /** @@see pwbuilder.core.StateMachine */
    public String generateProcTypeDecls() {
      return
       "\n /** ProcType Declarations of the TextResourceManager_"+cid+" component */ \n"+ 
      generateRunProcTypeDecl();
    }

    private String generateRunProcTypeDecl() {
      int len = twCids.length; 
      String result= 
        "active proctype run_"+cid+"() {\n"+ 
        " TRMEvent event; event.source="+cid+";\n"+
        " byte twid=0;\n"+
        " LOOP: atomic { \n"+
        "   (";
      for (int i=0;i<len;i++) {
        if (i>0) result=result+" && ";
        result = result+"!"+CName+"["+i+"]";
      }
      result = result+") -> \n"+
        "    if \n";
      for (int i=0;i<len;i++) 
        result=result+
          "      :: "+generateGrantTest(i)+" \n";  
      result=result+"      ::else -> twid=0; \n"+
        "    fi;\n"+
        " } \n"+
        " if \n";
      for (int i=0;i<len;i++) 
        result = result+"   ::(twid=="+(twCids[i]+1)+
          ") -> receiveTRMEvent_"+twCids[i]+"(event);\n";
      result=result+"   :: else -> skip; \n"+
      " fi; \n" +
      " goto LOOP \n"+
      "}";  
      return result;
    }

    private String generateGrantTest(int ind) {
      int len = twCids.length; 
      String result = "("+TName+"["+ind+"]";
      for (int i=0;i<len;i++) 
        if (i!=ind) 
          result=result+" && ("+NName+"["+i+"] || "+colsName+"["+ind+"]."+rowsName+"["+i+"])";
      result = result+") -> "+TName+"["+ind+"]=false;"+CName+"["+ind+"]=true;";
      for (int i=0;i<len;i++) 
        if (i!=ind) result=result+colsName+"["+i+"]."+rowsName+"["+ind+"]=true;";
      result=result+"\n      twid="+(twCids[ind]+1)+";";
      return result;
    } 

    private String generateCidToPosMapping() {
      int len = twCids.length; 
      String result = "  if \n";
      for (int i=0;i<len;i++) 
        result = result+"    :: (event.source=="+twCids[i]+") -> TWEventAction_"+cid+"("+i+",event.isRequest);\n";
      return result+ "    :: else -> assert(0); \n  fi;";
    }

	private synchronized void writeObject(ObjectOutputStream outStream)
	  throws IOException {
		outStream.defaultWriteObject();
	}
	
    private synchronized void readObject(ObjectInputStream inStream)
	  throws ClassNotFoundException, IOException {
		inStream.defaultReadObject();
    }
}
