package peterson;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import pwbuilder.core.*;

/**
 * The TextResourceManager is an object that allows multiple 
 * TextWriters to write to the same TextResource simultaneously
 * without errors by implementing a request / grant / release
 * protocol (Peterson-like).
 * 
 * The TextWriter will send a request to a manager, notifying it
 * that it wants to write to a given resource.  The 
 * TextResourceManager then replies to the writer with a grant
 * once the resource in question is available.  Once completed with
 * writing, the TextWriter should send a release to the manager,
 * notifying it that the resource is free. 
 *  
 * @author      Brian Knolhoff
 */
public class TextResourceManager implements Serializable, 
  TWListener, StateMachineAvailable, ActionListener, Runnable {

    private transient Vector listeners = new Vector();
    private boolean locked=false;
    private boolean stop=false;
    private Vector requests = new Vector();
    

    private StateMachine stateMachine = new StateMachine("***put Promela here***");
    private transient Thread t = null;

    /** get the state machine for this object */
    public StateMachine getStateMachine() {return stateMachine;}

    public void run() {
      System.out.println(this+":"+"stop="+stop+", listeners="+listeners.size());
      while(!stop) {
        synchronized(this) {
          try {wait(2000);} catch(InterruptedException e) {}
          System.out.println(this+":"+", requests="+requests.size());
          if (requests.size()>0) {
            System.out.println(this+":"+", locked="+locked);
            if (!locked) {
              try{grant((TRMListener)requests.get(0));
                locked=true;
                requests.remove(0);
              } catch (Exception e) {}
            }
            for (int i=0;i<requests.size();i++) 
              try{reject((TRMListener)requests.get(i));
              } catch (Exception e) {}
            requests.removeAllElements();
          }
        }
      }
    }

    public synchronized void receiveTWEvent(TWEvent event) {
      System.out.println(this+":"+"TWEvent received="+event);
      TRMListener listener = event.getTRMListener();
      if (event instanceof RequestEvent) {
        //System.out.println(this+"listeners.contains(listener)="+listeners.contains(listener));
        //if (listeners.contains(listener)) 
        requests.add(listener);
      }
      if (event instanceof ReleaseEvent) synchronized(this) {locked=false;} 
    }

    private void grant(TRMListener listener) {
      listener.receiveTRMEvent(new GrantEvent(this));
    }

    private void reject(TRMListener listener) {
      listener.receiveTRMEvent(new RejectEvent(this));
    }

    public synchronized void addTRMListener(TRMListener l) {
      listeners.addElement(l);    
    }

    public synchronized void removeTRMListener(TRMListener l) {
      listeners.removeElement(l);    
      requests.removeElement(l);
    } 

    public synchronized void actionPerformed(ActionEvent e) {
      stop=!stop;
      if (!stop) {
        try{
         t = new Thread(this);
         t.start();
         System.out.println("Starting TRM thread");
        } catch (Exception exc) {
          exc.printStackTrace();
        }
      }
    }

    private void writeObject(ObjectOutputStream outStream) throws IOException {
      Vector listenersClone;
      synchronized(this) {
        outStream.defaultWriteObject();
        listenersClone = (Vector)(listeners.clone());
      }

      //serialize all serializable elements in the vector supplied.
      Iterator listenerIterator = listenersClone.iterator();
      while(listenerIterator.hasNext()) {
        Object aListener = listenerIterator.next();
        if(aListener instanceof Serializable) outStream.writeObject(aListener);
      }
    }

    private void readObject(ObjectInputStream inStream) throws ClassNotFoundException, IOException {
      synchronized(this) {
        inStream.defaultReadObject();
        if(listeners == null) listeners = new Vector();
      }

      Object listener;
      while(inStream.available() > 0) {
        listener = inStream.readObject();
        if(listener instanceof TRMListener)
          addTRMListener((TRMListener)listener);
      }
    }
  }
