package pwbuilder.spin;
import pwbuilder.core.*;
import java.util.Vector;
import java.util.HashMap;
import java.awt.*;
import java.beans.*;
import java.io.*;



public class Verifier {

  static final String MODEL_FILE_NAME="model";

  private String spinPath;
  private String spinOptions;
  private String ccPath;
  private String ccOptions;
  private String verifierCommand;
  private VerifierFrame frame=null; 
  
  public void setSpinPath(String val) {spinPath=val;}  
  public String getSpinPath() {return spinPath;}

  public void setCCPath(String val) {ccPath=val;}  
  public String getCCPath() {return ccPath;}

  public void setSpinOptions(String val) {spinOptions=val;}  
  public String getSpinOptions() {return spinOptions;}

  public void setCCOptions(String val) {ccOptions=val;}  
  public String getCCOptions() {return ccOptions;}

  public void setVerifierCommand(String val) {verifierCommand=val;}  
  public String getVerifierCommand() {return verifierCommand;}

  public void verify(SystemDescr system) {
    if (frame==null) {frame = new VerifierFrame();}
    TextArea compilerOut = frame.getCompilerOut();
    TextArea verifierOut = frame.getVerifierOut();
    compilerOut.setText("");
    verifierOut.setText("");
    frame.show();
    //Compilation
    compilerOut.append("Generating promela description...\n");
    String promela = getPromelaCode(system);
    File modelFile = new File(MODEL_FILE_NAME);
    compilerOut.append("Saving description to "+modelFile.getAbsolutePath()+"\n");
    try{ saveToFile(promela,modelFile);
    } catch (Exception e) { compilerOut.append("File operation error: "+e.getMessage()+"\n"); 
      e.printStackTrace();
    }
    String spinCommand = spinPath+" "+spinOptions+" "+modelFile.getAbsolutePath();
    //compilerOut.append(spinPath+" "+spinOptions+" "+MODEL_FILE_NAME);
    compilerOut.append(spinCommand+"\n");
    compilerOut.append(execute(spinCommand));

    String ccCommand = ccPath+" "+ccOptions;
    compilerOut.append(ccCommand+"\n");
    compilerOut.append(execute(ccCommand));

    compilerOut.append(verifierCommand+"\n");
    verifierOut.append(execute(verifierCommand));
  }

  private String execute(String command) {
    try{
      Runtime rt = Runtime.getRuntime();
      Process proc = rt.exec(command);
      InputStream in = proc.getInputStream();
//      InputStream err= proc.getErrorStream();
      BufferedReader inReader=new BufferedReader(new InputStreamReader(in));
//      BufferedReader errReader=new BufferedReader(new InputStreamReader(in));
      String line;
      String result="";
      while ((line=inReader.readLine())!=null) {
        result=result+line+"\n";
      }
      return result;
    } catch (Exception e) {
      e.printStackTrace();
      return "Error executing "+command+": "+e.getMessage()+"\n";
    }
  }

  private void saveToFile(String content,File file) throws Exception {
    PrintWriter out
      = new PrintWriter(new BufferedWriter(new FileWriter(file)));
    out.print(content);
    try{out.flush(); out.close();} catch (Exception e) {}
  }

  private String getPromelaCode(SystemDescr system) {
    String promelaEvents = generatePromelaEventTypes(getEventSetDescriptors(system));
    String promelaComps = generatePromela(getStateMachines(system));
    return promelaEvents+"\n"+promelaComps;
  }

  private StateMachine[] getStateMachines(SystemDescr system) {
    ComponentDescr[] comps = system.getComponents();
    Vector sms = new Vector();
    /** Generating headers */
    for(int i=0;i<comps.length;i++) {
      Object compObj = comps[i].getComponentObject();
      if (compObj instanceof StateMachineAvailable) {
        StateMachine sm = ((StateMachineAvailable)compObj).getStateMachine(system); 
        if (sm!=null) sms.add(sm);
      }
    }
    return (StateMachine[])sms.toArray(new StateMachine[0]);
  }

  
  private EventSetDescriptor[] getEventSetDescriptors(SystemDescr system) {
    //implementation should be fixed. Should take description from the
    //event's class
    ConnectionDescr[] cons = system.getConnections();
    HashMap esds = new HashMap();
    for (int i=0;i<cons.length;i++) {
      EventSetDescriptor esd = cons[i].getEventSetDescr();
      if (esd==null) continue;
      if (esd.getValue("typedef")!=null) esds.put(esd.getName(),esd);
    }
    return (EventSetDescriptor[])esds.values().toArray(new EventSetDescriptor[0]);
  }

  private String generatePromelaEventTypes(EventSetDescriptor[] esds) {
    String result="";
    for (int i=0;i<esds.length;i++) {
      String tdef = (String)esds[i].getValue("typedef");
      if (tdef!=null) result=result+
        "/* Datatype for the "+esds[i].getName()+" event */\n"+
          tdef+
          "\n";
    }
    return result;
  }

  private String generatePromela(StateMachine[] machines) {
    String globals="";
    String proctypes="";
    for (int i=0;i<machines.length;i++) {
      globals = globals+"\n"+machines[i].generateGlobalVars();
      proctypes = proctypes+"\n"+machines[i].generateProcTypeDecls();
    }
    return globals+"\n"+proctypes;
  }
}
