package pwbuilder.integration;
import pwbuilder.core.*;
import pwbuilder.spin.*;
import java.beans.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import sun.beanbox.BeanBox;
import sun.beanbox.BeanBoxFrame;
import java.util.Vector;
import java.util.HashMap;



public privileged aspect IntegrateCheckerMenuItem implements ActionListener {
  final static String VERIFY_MENU_LABEL = "Verify";
  final static String VERIFY_MENUITEM_LABEL = "Run";
  private BeanBox beanBox = null;
  private BeanBoxFrame frame = null;

  private Verifier verifier = null;
    
  after(MenuBar bar,BeanBox beanBox) returning(Object result): 
    execution(void BeanBox.updateMenuBar(MenuBar)) && args(bar) && this(beanBox) {
      //System.out.println("Adding new menu item for verification purposes!");
      if (this.beanBox==null) this.beanBox = beanBox;
      if (this.frame==null) frame = beanBox.getFrame();
      if (!hasVerifyMenu(bar)) {
        Menu m = new Menu(VERIFY_MENU_LABEL); 
        MenuItem item = new MenuItem(VERIFY_MENUITEM_LABEL); 
        m.add(item);
        item.addActionListener(this);
        bar.add(m);
      }
    }

  private boolean hasVerifyMenu(MenuBar bar) {
    int n = bar.getMenuCount();
    for (int i=0;i<n;i++) 
      if (VERIFY_MENU_LABEL.equals(bar.getMenu(i).getLabel()))
        return true;
    return false;
  }

  public void actionPerformed(ActionEvent e) {
    System.out.println("System verification should be run here!");
    if (verifier==null) buildVerifier();
    SystemDescr system = IntegrateSystemDescr.getSystemDescr();
    verifier.verify(system);
    //run the checker!
    //System.out.println(getPromelaCode());
  }

  private void buildVerifier() {
    verifier=new Verifier();
    verifier.setSpinPath(System.getProperty("spin.path"));
    verifier.setSpinOptions(System.getProperty("spin.options"));
    verifier.setCCPath(System.getProperty("cc.path"));
    verifier.setCCOptions(System.getProperty("cc.options"));
    verifier.setVerifierCommand(System.getProperty("verifier.command"));
  }
/*
  private String getPromelaCode() {
    SystemDescr system = IntegrateSystemDescr.getSystemDescr();
    String promelaEvents = generatePromelaEventTypes(
      getEventSetDescriptors(system));
    String promelaComps = generatePromela(
        getStateMachines(system));
    return promelaEvents+"\n"+promelaComps;
  }

  private StateMachine[] getStateMachines(SystemDescr system) {
    ComponentDescr[] comps = system.getComponents();
    Vector sms = new Vector();
    for(int i=0;i<comps.length;i++) {
      Object compObj = comps[i].getComponentObject();
      if (compObj instanceof StateMachineAvailable) {
        StateMachine sm = ((StateMachineAvailable)compObj).getStateMachine(system); 
        if (sm!=null) sms.add(sm);
      }
    }
    return (StateMachine[])sms.toArray(new StateMachine[0]);
  }

  
  private EventSetDescriptor[] getEventSetDescriptors(SystemDescr system) {
    //implementation should be fixed. Should take description from the
    //event's class
    ConnectionDescr[] cons = system.getConnections();
    HashMap esds = new HashMap();
    for (int i=0;i<cons.length;i++) {
      EventSetDescriptor esd = cons[i].getEventSetDescr();
      if (esd==null) continue;
      if (esd.getValue("typedef")!=null) esds.put(esd.getName(),esd);
    }
    return (EventSetDescriptor[])esds.values().toArray(new EventSetDescriptor[0]);
  }
*/
/*
  private String generatePromelaEventTypes(EventSetDescriptor[] esds) {
    String result="";
    for (int i=0;i<esds.length;i++) {
      String tdef = (String)esds[i].getValue("typedef");
      if (tdef!=null) result=result+
          tdef+
          "\n";
    }
    return result;
  }

  private String generatePromela(StateMachine[] machines) {
    String globals="";
    String proctypes="";
    for (int i=0;i<machines.length;i++) {
      globals = globals+"\n"+machines[i].generateGlobalVars();
      proctypes = proctypes+"\n"+machines[i].generateProcTypeDecls();
    }
    return globals+"\n"+proctypes;
  } */
}
