package pwbuilder.core;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.io.*;

/** JavaBeans implementation of the ConnectionDescr interface.
  * @author Sergei Kojarski */
public class ConnectionDescrImpl implements ConnectionDescr, Serializable {

  private ComponentDescr targetComponentDescr;
  private ComponentDescr sourceComponentDescr;
  private MethodDescr targetMethodDescr;
  private transient EventSetDescriptor eventSetDescr;
  private String eventName;

  /** @@see pwbuilder.core.ConnectionDescr */
  public ComponentDescr getTargetComponent() {
    return targetComponentDescr;
  }

  /** Sets a description of the target component */
  public void setTargetComponent(ComponentDescr cd) {
    targetComponentDescr = cd;
  }

  /** @@see pwbuilder.core.ConnectionDescr */
  public MethodDescr getTargetMethod() {
    return targetMethodDescr;
  }

  /** Sets a target method's description */
  public void setTargetMethod(MethodDescr md) {
    targetMethodDescr = md;
  }

  /** @@see pwbuilder.core.ConnectionDescr */
  public ComponentDescr getSourceComponent() {
    return sourceComponentDescr;
  }

  /** Sets a description of the source component */
  public void setSourceComponent(ComponentDescr cd) {
    sourceComponentDescr = cd;
  }

  /** @@see pwbuilder.core.ConnectionDescr */
  public EventSetDescriptor getEventSetDescr() {
    return eventSetDescr;
  }

  /** Sets a description of the event type */
  public void setEventSetDescr(EventSetDescriptor esd) {
    eventSetDescr = esd;
    eventName=esd.getName();
  }

  private synchronized void writeObject(ObjectOutputStream outStream)
    throws IOException {
      outStream.defaultWriteObject();
    }

  private synchronized void readObject(ObjectInputStream inStream)
    throws ClassNotFoundException, IOException {
      eventSetDescr=null;
      inStream.defaultReadObject();
      try{
      Object srcObj = sourceComponentDescr.getComponentObject();  
      EventSetDescriptor[] esds = 
        Introspector.getBeanInfo(srcObj.getClass()).getEventSetDescriptors();
      for (int i=0;i<esds.length;i++) 
        if (esds[i].getName().equals(eventName)) {this.eventSetDescr=esds[i]; break;}
      } catch (Exception e) {
        e.printStackTrace();
      }
    }

}
