package peterson;
import java.lang.reflect.*;
import java.awt.*;
import java.beans.*;

/**
 * provides bean info information for the TextResourceManager class
 *
 * @author      Brian Knolhoff
 */
public class TextResourceManagerBeanInfo extends SimpleBeanInfo
{
  private static final Class BEAN_CLASS = TextResourceManager.class;
  private static final Class TRM_LISTENER_CLASS = TRMListener.class;

  /**
    * Provides event set descriptors so that clients can register for
    * change events based on the specific value (output or
    * carryOut) they want to get updates for.
    *
    * @return      Array containing event entries for each of the two types
    *              of possible updates.
    */
  public EventSetDescriptor[] getEventSetDescriptors()
  {
    try {
      //create an event descriptor so that the listeners
      //can register for events
	  EventSetDescriptor trmEvent = new EventSetDescriptor(
		      BEAN_CLASS,
		      "tRM",
			  TRM_LISTENER_CLASS,
			  "receiveTRMEvent");

      return new EventSetDescriptor[] { trmEvent };
    }
    catch(IntrospectionException e)
    {
      throw new Error(e.toString());
    }
  }
}
