/*
 * Decompiled with CFR 0.152.
 */
package peterson;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import peterson.TextResource;
import peterson.TextResourceManager;
import peterson.TextWriter;
import pwbuilder.core.ComponentDescr;
import pwbuilder.core.ConnectionDescr;
import pwbuilder.core.StateMachine;
import pwbuilder.core.SystemDescr;

public class TWStateMachine
implements StateMachine {
    private SystemDescr system;
    private TextWriter tw;
    private int cid;
    private int trmCid;
    private int trCid;
    private String notifyName;

    public TWStateMachine(SystemDescr systemDescr, TextWriter textWriter) {
        this.system = systemDescr;
        this.tw = textWriter;
        ComponentDescr componentDescr = systemDescr.getComponent((Object)textWriter);
        this.cid = componentDescr.getId();
        this.notifyName = "notify_" + this.cid;
        this.trmCid = -1;
        this.trCid = -1;
        ConnectionDescr[] connectionDescrArray = systemDescr.getConnections();
        int n = 0;
        while (n < connectionDescrArray.length) {
            ComponentDescr componentDescr2 = connectionDescrArray[n].getSourceComponent();
            ComponentDescr componentDescr3 = connectionDescrArray[n].getTargetComponent();
            if (componentDescr2.getId() == this.cid) {
                if (componentDescr3.getComponentObject() instanceof TextResourceManager) {
                    this.trmCid = componentDescr3.getId();
                }
                if (componentDescr3.getComponentObject() instanceof TextResource) {
                    this.trCid = componentDescr3.getId();
                }
                if (this.trCid >= 0 && this.trmCid >= 0) break;
            }
            ++n;
        }
    }

    public String generateGlobalVars() {
        String string = "\n /** Global Declarations of the TextWriter" + this.cid + " component */ \n" + "bool " + this.notifyName + " = false; ";
        String string2 = "inline receiveTRMEvent_" + this.cid + "(ev) {atomic{" + this.notifyName + "=true;}}";
        return string + "\n\n" + string2 + "\n";
    }

    public String generateProcTypeDecls() {
        String string = "\n /** ProcType Declarations of the TextWriter" + this.cid + " component */ \n" + "active proctype run_" + this.cid + "() {\n" + "  TWEvent requestEvent,releaseEvent;\n" + "  requestEvent.source=" + this.cid + ";\n" + "  requestEvent.isRequest = true;\n" + "  releaseEvent.source=" + this.cid + ";\n" + "  releaseEvent.isRequest = false;\n" + "  TextUpdateEvent textEvent;\n" + "  textEvent.source=" + this.cid + ";\n" + "\n" + "  LOOP:\n";
        string = this.trmCid == -1 ? string + "  assert(0);\n" : string + "  receiveTWEvent_" + this.trmCid + "(requestEvent);\n";
        string = string + "  atomic {(" + this.notifyName + "==true) -> " + this.notifyName + "=false;}\n";
        string = this.trCid == -1 ? string + "  assert(0);\n" : string + "  receiveTextUpdateEvent_" + this.trCid + "(textEvent);\n";
        string = this.trmCid == -1 ? string + "  assert(0);\n" : string + "  receiveTWEvent_" + this.trmCid + "(releaseEvent);\n";
        string = string + "  goto LOOP\n" + "} \n";
        return string;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }
}

