/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.encapsulatedEvents;

import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.EventObject;
import java.util.Hashtable;
import sunw.demo.encapsulatedEvents.EncapsulatedEvent;
import sunw.demo.encapsulatedEvents.EncapsulatedEventAdaptor;
import sunw.demo.encapsulatedEvents.EncapsulatedEventListener;
import sunw.demo.encapsulatedEvents.EncapsulatedEventManager;
import sunw.demo.encapsulatedEvents.EventMonitor;

final class EventManager
implements EncapsulatedEventManager,
EncapsulatedEventListener {
    private int eventCnt = 1;
    private EventMonitor em;
    private transient Hashtable sources = new Hashtable();

    EventManager(EventMonitor eventMonitor) {
        this.em = eventMonitor;
    }

    public void addEncapsulatedEventListener(Object object, EncapsulatedEventListener encapsulatedEventListener) {
        this.addEncapsulatedEventListener(object, encapsulatedEventListener, this.getSourceEventListenerInterfaces(object));
    }

    public synchronized void addEncapsulatedEventListener(Object object, EncapsulatedEventListener encapsulatedEventListener, Class[] classArray) {
        if (object == null) {
            throw new NullPointerException("Source");
        }
        if (encapsulatedEventListener == null) {
            throw new NullPointerException("Listener");
        }
        if (classArray == null) {
            throw new NullPointerException("Interfaces");
        }
        Hashtable<Class, EncapsulatedEventAdaptor> hashtable = (Hashtable<Class, EncapsulatedEventAdaptor>)this.sources.get(object);
        if (hashtable == null) {
            hashtable = new Hashtable<Class, EncapsulatedEventAdaptor>();
            this.sources.put(object, hashtable);
        }
        int n = 0;
        while (n < classArray.length) {
            EncapsulatedEventAdaptor encapsulatedEventAdaptor = (EncapsulatedEventAdaptor)hashtable.get(classArray[n]);
            if (encapsulatedEventAdaptor == null) {
                try {
                    encapsulatedEventAdaptor = EncapsulatedEventAdaptor.getEncapsulatedEventAdaptor(classArray[n], object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Cant create adaptor class");
                }
                catch (InstantiationException instantiationException) {
                    System.err.println("Cant instantiate adaptor");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("illegal access");
                }
                catch (IntrospectionException introspectionException) {
                    System.err.println("introspection error");
                }
                if (encapsulatedEventAdaptor != null) {
                    EncapsulatedEventAdaptor encapsulatedEventAdaptor2 = encapsulatedEventAdaptor;
                    synchronized (encapsulatedEventAdaptor2) {
                        encapsulatedEventAdaptor.addEncapsulatedEventListener(encapsulatedEventListener);
                    }
                    hashtable.put(classArray[n], encapsulatedEventAdaptor);
                    this.em.append("Listening to: " + classArray[n].getName() + " on: " + object + "\n");
                } else {
                    hashtable.put(classArray[n], null);
                }
            }
            ++n;
        }
    }

    public void encapsulatedEvent(EncapsulatedEvent encapsulatedEvent) {
        Object object = encapsulatedEvent.getEventSource();
        EventObject eventObject = encapsulatedEvent.getEvent();
        this.em.append(String.valueOf(this.eventCnt++) + " Source: [" + object + "] Event: [" + eventObject + "]" + "\n");
    }

    public Class[] getSourceEventListenerInterfaces(Object object) {
        EventSetDescriptor[] eventSetDescriptorArray = null;
        try {
            eventSetDescriptorArray = Introspector.getBeanInfo(object.getClass()).getEventSetDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            System.err.println("Failed to introspect");
        }
        Class[] classArray = eventSetDescriptorArray != null && eventSetDescriptorArray.length > 0 ? new Class[eventSetDescriptorArray.length] : new Class[]{};
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = eventSetDescriptorArray[n].getListenerType();
            ++n;
        }
        return classArray;
    }

    public void removeEncapsulatedEventListener(Object object, EncapsulatedEventListener encapsulatedEventListener) {
        this.removeEncapsulatedEventListener(object, encapsulatedEventListener, this.getSourceEventListenerInterfaces(object));
    }

    public synchronized void removeEncapsulatedEventListener(Object object, EncapsulatedEventListener encapsulatedEventListener, Class[] classArray) {
        if (object == null) {
            throw new NullPointerException("Source");
        }
        if (encapsulatedEventListener == null) {
            throw new NullPointerException("Listener");
        }
        if (classArray == null) {
            throw new NullPointerException("Interfaces");
        }
        Hashtable hashtable = (Hashtable)this.sources.get(object);
        if (hashtable == null) {
            throw new IllegalArgumentException("Source");
        }
        int n = 0;
        while (n < classArray.length) {
            EncapsulatedEventAdaptor encapsulatedEventAdaptor = (EncapsulatedEventAdaptor)hashtable.get(classArray[n]);
            if (encapsulatedEventAdaptor != null) {
                encapsulatedEventAdaptor.removeEncapsulatedEventListener(encapsulatedEventListener);
                EncapsulatedEventAdaptor encapsulatedEventAdaptor2 = encapsulatedEventAdaptor;
                synchronized (encapsulatedEventAdaptor2) {
                    if (encapsulatedEventAdaptor.getEncapsulatedListenerCount() == 0) {
                        try {
                            encapsulatedEventAdaptor.setSource(null);
                        }
                        catch (Exception exception) {
                            System.err.println("failed to unregister source");
                        }
                    }
                    this.em.append("No longer listening to: " + classArray[n].getName() + " on: " + object + "\n");
                    hashtable.put(classArray[n], null);
                }
            }
            ++n;
        }
    }
}

