/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import sunw.demo.classfile.ClassFile;

abstract class ConstantPoolEntry {
    static final byte CONSTANT_UTF8 = 1;
    static final byte CONSTANT_UNICODE = 2;
    static final byte CONSTANT_INTEGER = 3;
    static final byte CONSTANT_FLOAT = 4;
    static final byte CONSTANT_LONG = 5;
    static final byte CONSTANT_DOUBLE = 6;
    static final byte CONSTANT_CLASS = 7;
    static final byte CONSTANT_STRING = 8;
    static final byte CONSTANT_FIELDREF = 9;
    static final byte CONSTANT_METHODREF = 10;
    static final byte CONSTANT_INTERFACEMETHODREF = 11;
    static final byte CONSTANT_NAMEANDTYPE = 12;
    private byte tag;
    private ClassFile classFile;
    private short index = (short)-1;

    ConstantPoolEntry(byte by, ClassFile classFile) {
        this.tag = by;
        this.classFile = classFile;
    }

    ConstantPoolEntry(byte by, ClassFile classFile, short s) {
        this.tag = by;
        this.classFile = classFile;
        this.index = s;
    }

    protected void addToConstantPool() {
        if (this.index == -1) {
            this.index = this.classFile.addConstantPoolEntry(this);
        }
    }

    protected static boolean debug() {
        return ClassFile.debug();
    }

    public abstract boolean equals(Object var1);

    ClassFile getClassFile() {
        return this.classFile;
    }

    short getConstantPoolIndex() {
        if (this.index == -1) {
            this.index = this.classFile.addConstantPoolEntry(this);
        }
        return this.index;
    }

    byte getTag() {
        return this.tag;
    }

    public abstract int hashCode();

    abstract void write(DataOutputStream var1) throws IOException;
}

