/*
 * Decompiled with CFR 0.152.
 */
package peterson;

import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import peterson.TRMEvent;
import peterson.TRMListener;
import peterson.TWEvent;
import peterson.TWListener;
import peterson.TWStateMachine;
import peterson.TextUpdateEvent;
import peterson.TextUpdateListener;
import pwbuilder.core.StateMachine;
import pwbuilder.core.StateMachineAvailable;
import pwbuilder.core.SystemDescr;

public class TextWriter
extends Panel
implements ActionListener,
TRMListener,
Serializable,
StateMachineAvailable,
Runnable {
    private static final String SAMPLE_MSG = "Sample Message";
    private static final int MESSAGE_FIELD_SIZE = 20;
    private static final int NUMBER_OF_REQUESTS = 4;
    private TextField messageField_ = new TextField("Sample Message", 20);
    private transient Thread t = null;
    private StateMachine stateMachine_ = null;
    private TWListener manager = null;
    private TextUpdateListener resource = null;
    private static int instancesNum = 0;
    private int thisInstanceNum;

    public TextWriter() {
        this.add(this.messageField_);
        this.thisInstanceNum = ++instancesNum;
    }

    public String toString() {
        return "TW" + this.thisInstanceNum;
    }

    public synchronized void receiveTRMEvent(TRMEvent tRMEvent) {
        this.notifyAll();
    }

    public void run() {
        if (this.manager == null || this.resource == null) {
            return;
        }
        System.out.println(this + ": STARTED");
        int n = 0;
        while (n < 4) {
            ++n;
            TextWriter textWriter = this;
            synchronized (textWriter) {
                this.manager.receiveTWEvent(new TWEvent(this, true));
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            System.out.println(this + " is granted access to the CS");
            this.fireTextUpdateEvent();
            this.manager.receiveTWEvent(new TWEvent(this, false));
        }
        System.out.println(this + ": STOPPED!");
    }

    private void fireTextUpdateEvent() {
        String string = this.messageField_.getText();
        int n = string.length();
        int n2 = 0;
        while (n2 <= n) {
            String string2 = "\n";
            if (n2 < n) {
                string2 = String.valueOf(string.charAt(n2));
            }
            TextUpdateEvent textUpdateEvent = new TextUpdateEvent(this, string2);
            this.resource.receiveTextUpdateEvent(textUpdateEvent);
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (this.t == null || !this.t.isAlive()) {
            try {
                this.t = new Thread(this);
                this.t.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public StateMachine getStateMachine(SystemDescr systemDescr) {
        return new TWStateMachine(systemDescr, this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    public void addTWListener(TWListener tWListener) {
        this.manager = tWListener;
    }

    public void removeTWListener(TWListener tWListener) {
        if (this.manager == tWListener) {
            this.manager = null;
        }
    }

    public void addTextUpdateListener(TextUpdateListener textUpdateListener) {
        this.resource = textUpdateListener;
    }

    public void removeTextUpdateListener(TextUpdateListener textUpdateListener) {
        if (this.resource == textUpdateListener) {
            this.resource = null;
        }
    }
}

