/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.molecule;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import sunw.demo.molecule.Atom;
import sunw.demo.molecule.Matrix3D;
import sunw.demo.molecule.XYZChemModel;

public class Molecule
extends Panel
implements Serializable,
MouseListener,
MouseMotionListener {
    private static int ourVersion = 3;
    XYZChemModel md;
    float xfac;
    int prevx;
    int prevy;
    float xtheta;
    float ytheta;
    float scalefudge;
    Matrix3D amat;
    Matrix3D tmat;
    String message = null;
    Image backBuffer;
    Graphics backGC;
    int width;
    int height;
    private String moleculeName = "HyaluronicAcid";

    public Molecule() {
        this.reset();
        this.amat.yrot(20.0);
        this.amat.xrot(20.0);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public String getMoleculeName() {
        return this.moleculeName;
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 150);
    }

    public synchronized void initialize() {
        InputStream inputStream = null;
        try {
            float f;
            float f2;
            this.width = this.getSize().width;
            this.height = this.getSize().height;
            inputStream = this.getClass().getResourceAsStream(String.valueOf(this.moleculeName) + ".xyz");
            XYZChemModel xYZChemModel = new XYZChemModel(inputStream);
            Atom.setPanel(this);
            this.md = xYZChemModel;
            xYZChemModel.findBB();
            float f3 = xYZChemModel.xmax - xYZChemModel.xmin;
            float f4 = xYZChemModel.ymax - xYZChemModel.ymin;
            float f5 = xYZChemModel.zmax - xYZChemModel.zmin;
            if (f4 > f3) {
                f3 = f4;
            }
            if (f5 > f3) {
                f3 = f5;
            }
            this.xfac = 0.7f * ((f2 = (float)this.width / f3) < (f = (float)this.height / f3) ? f2 : f) * this.scalefudge;
            this.backBuffer = this.createImage(this.width, this.height);
            this.backGC = this.backBuffer.getGraphics();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.md = null;
            this.message = exception.toString();
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.rotate(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.prevx = mouseEvent.getX();
        this.prevy = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public synchronized void paint(Graphics graphics) {
        if (this.backBuffer == null || this.getSize().width != this.width || this.getSize().height != this.height) {
            this.initialize();
        }
        if (this.md != null) {
            this.md.mat.unit();
            this.md.mat.translate(-(this.md.xmin + this.md.xmax) / 2.0f, -(this.md.ymin + this.md.ymax) / 2.0f, -(this.md.zmin + this.md.zmax) / 2.0f);
            this.md.mat.mult(this.amat);
            this.md.mat.scale(this.xfac, -this.xfac, 16.0f * this.xfac / (float)this.getSize().width);
            this.md.mat.translate(this.getSize().width / 2, this.getSize().height / 2, 8.0f);
            this.md.transformed = false;
            this.backGC.setColor(this.getBackground());
            this.backGC.fillRect(0, 0, this.getSize().width, this.getSize().height);
            this.md.paint(this.backGC);
            graphics.drawImage(this.backBuffer, 0, 0, this);
        } else if (this.message != null) {
            graphics.drawString("Error in model:", 3, 20);
            graphics.drawString(this.message, 10, 40);
        }
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.reset();
        if (objectInputStream.readInt() != ourVersion) {
            throw new IOException("Molecule.readObject: version mismatch");
        }
        this.moleculeName = (String)objectInputStream.readObject();
    }

    private synchronized void reset() {
        this.md = null;
        this.xfac = 0.0f;
        this.prevx = 0;
        this.prevy = 0;
        this.xtheta = 0.0f;
        this.ytheta = 0.0f;
        this.scalefudge = 1.0f;
        this.amat = new Matrix3D();
        this.tmat = new Matrix3D();
        this.message = null;
        this.backBuffer = null;
        this.backGC = null;
    }

    private synchronized void rotate(int n, int n2) {
        this.tmat.unit();
        float f = (float)(this.prevy - n2) * (360.0f / (float)this.width);
        float f2 = (float)(n - this.prevx) * (360.0f / (float)this.height);
        this.tmat.xrot(f);
        this.tmat.yrot(f2);
        this.amat.mult(this.tmat);
        this.repaint();
        this.prevx = n;
        this.prevy = n2;
    }

    public synchronized void rotateOnX() {
        int n = (this.prevx + 10) % this.width;
        int n2 = this.prevy;
        this.rotate(n, n2);
    }

    public synchronized void rotateOnY() {
        int n = this.prevx;
        int n2 = (this.prevy + 10) % this.height;
        this.rotate(n, n2);
    }

    public synchronized void rotateX(ActionEvent actionEvent) {
        this.rotateOnX();
    }

    public synchronized void rotateY(ActionEvent actionEvent) {
        this.rotateOnY();
    }

    public void setMoleculeName(String string) {
        this.moleculeName = string;
        this.reset();
        this.repaint();
    }

    public synchronized void update(Graphics graphics) {
        if (this.backBuffer == null) {
            graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.paint(graphics);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(ourVersion);
        objectOutputStream.writeObject(this.moleculeName);
    }
}

