/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.jelly;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public class JellyBean
extends Component {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private Color ourColor = Color.orange;
    private int ourPriceInCents = 2;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized Color getColor() {
        return this.ourColor;
    }

    public Dimension getPreferredSize() {
        return new Dimension(60, 40);
    }

    public synchronized int getPriceInCents() {
        return this.ourPriceInCents;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.ourColor);
        graphics.fillArc(5, 5, 30, 30, 0, 360);
        graphics.fillArc(25, 5, 30, 30, 0, 360);
        graphics.fillRect(20, 5, 20, 30);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setColor(Color color) {
        Color color2 = this.ourColor;
        this.ourColor = color;
        this.changes.firePropertyChange("color", color2, color);
        this.repaint();
    }

    public void setPriceInCents(int n) throws PropertyVetoException {
        int n2 = this.ourPriceInCents;
        this.vetos.fireVetoableChange("priceInCents", new Integer(n2), new Integer(n));
        this.ourPriceInCents = n;
        this.changes.firePropertyChange("priceInCents", new Integer(n2), new Integer(n));
    }
}

