/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.select;

import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import sunw.demo.select.Util;
import sunw.demo.select.WorkerThread;

public class Select
extends Panel {
    private transient Label status;
    private transient List text;
    private static final int NO_WORK = 0;
    private static final int DO_SELECT = 3;
    private transient int work = 0;
    private static final String spaces = "                                                                                                                                 ";
    private String url = "jdbc:odbc:SQLSERVER";
    private String user = "guest";
    private String password = "guest";
    private String selectString = "";
    private int maxRows = 200;

    public Select() {
        this.setLayout(null);
        this.setSize(200, 300);
        this.initialize();
    }

    public synchronized void doLayout() {
        this.initialize();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.text.setBounds(0, 0, n, n2 - 40);
        this.status.setBounds(15, n2 - 30, 2 * n, 25);
    }

    void doWork() {
        while (true) {
            int n;
            if ((n = this.getWork()) != 3) {
                continue;
            }
            this.select();
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSQL() {
        return this.selectString;
    }

    public String getURL() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    synchronized int getWork() {
        this.work = 0;
        while (this.work == 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        int n = this.work;
        return n;
    }

    private void initialize() {
        if (this.text != null) {
            return;
        }
        this.removeAll();
        this.text = new List();
        this.text.setFont(new Font("Courier", 0, 12));
        this.add(this.text);
        this.status = new Label("", 0);
        this.add(this.status);
        this.doLayout();
        new WorkerThread(this);
    }

    public void layout() {
        this.doLayout();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initialize();
    }

    void select() {
        this.text.removeAll();
        Connection connection = Util.connect(this.url, this.user, this.password, this.status);
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.selectString);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int[] nArray = new int[n + 1];
            Vector[] vectorArray = new Vector[n + 1];
            int n2 = 1;
            while (n2 <= n) {
                nArray[n2] = resultSetMetaData.getColumnName(n2).length();
                vectorArray[n2] = new Vector();
                ++n2;
            }
            int n3 = 0;
            while (resultSet.next() && n3 < this.maxRows) {
                int n4 = 1;
                while (n4 <= n) {
                    String string = resultSet.getString(n4);
                    if (string == null) {
                        string = "";
                    }
                    if (string.length() > 80) {
                        string = string.substring(0, 80);
                    }
                    if (string.length() > nArray[n4]) {
                        nArray[n4] = string.length();
                    }
                    vectorArray[n4].addElement(string);
                    ++n4;
                }
                ++n3;
            }
            String string = "";
            int n5 = 1;
            while (n5 <= n) {
                String string2 = resultSetMetaData.getColumnName(n5);
                int n6 = nArray[n5] - string2.length();
                if (n5 != 1) {
                    ++n6;
                }
                if (n6 > 0) {
                    string = String.valueOf(string) + spaces.substring(0, n6);
                }
                string = String.valueOf(string) + string2;
                ++n5;
            }
            this.text.addItem(string);
            int n7 = 0;
            while (n7 < n3) {
                String string3 = "";
                int n8 = 1;
                while (n8 <= n) {
                    String string4 = (String)vectorArray[n8].elementAt(n7);
                    int n9 = nArray[n8] - string4.length();
                    if (n8 != 1) {
                        ++n9;
                    }
                    if (n9 > 0) {
                        string3 = String.valueOf(string3) + spaces.substring(0, n9);
                    }
                    string3 = String.valueOf(string3) + string4;
                    ++n8;
                }
                this.text.addItem(string3);
                ++n7;
            }
            if (this.text.getItemCount() >= this.maxRows) {
                this.status.setText("Only read first " + this.maxRows + " rows");
            } else {
                this.status.setText("Done.");
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Caught " + sQLException);
            this.status.setText("Caught " + sQLException);
        }
        Util.disconnect(connection);
        this.doLayout();
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setSQL(String string) {
        this.selectString = string;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public synchronized void update() {
        this.work = 3;
        this.notify();
    }

    public void update(ActionEvent actionEvent) {
        this.update();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.text.removeAll();
        objectOutputStream.defaultWriteObject();
    }
}

