/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.encapsulatedEvents;

import java.awt.Dimension;
import java.awt.TextArea;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Vector;
import sunw.demo.encapsulatedEvents.EventManager;

public final class EventMonitor
extends TextArea
implements BeanContextProxy {
    private static String msg = "Event Monitor\n";
    private static Dimension zero = new Dimension(0, 0);
    private transient EventManager em;
    private Vector beans = new Vector();
    private transient BeanContextChildSupport bccs = new BeanContextChildSupport(){

        protected void initializeBeanContextResources() {
            if (this.beanContext != null) {
                this.beanContext.addBeanContextMembershipListener(EventMonitor.this.bcml);
            }
        }

        protected void releaseBeanContextResources() {
            if (this.beanContext != null) {
                this.beanContext.removeBeanContextMembershipListener(EventMonitor.this.bcml);
            }
        }
    };
    private transient BeanContextMembershipListener bcml = new BeanContextMembershipListener(){

        public void childrenAdded(BeanContextMembershipEvent beanContextMembershipEvent) {
            Iterator iterator = beanContextMembershipEvent.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e.equals(EventMonitor.this) || e.equals(EventMonitor.this.bccs)) continue;
                EventMonitor.this.addEventSource(e);
            }
        }

        public void childrenRemoved(BeanContextMembershipEvent beanContextMembershipEvent) {
            Iterator iterator = beanContextMembershipEvent.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e.equals(EventMonitor.this) || e.equals(EventMonitor.this.bccs)) continue;
                EventMonitor.this.removeEventSource(e);
            }
        }
    };

    public EventMonitor() {
        super(msg, 4, 32);
        this.setEditable(false);
        this.setVisible(true);
        this.em = new EventManager(this);
    }

    public void addEventSource(Object object) {
        this.em.addEncapsulatedEventListener(object, this.em, this.em.getSourceEventListenerInterfaces(object));
        this.beans.addElement(object);
    }

    public BeanContextChild getBeanContextProxy() {
        return this.bccs;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        return dimension.equals(zero) ? super.getPreferredSize() : dimension;
    }

    public void initiateEventSourceMonitoring(EventObject eventObject) {
        this.addEventSource(eventObject.getSource());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.em = new EventManager(this);
        int n = 0;
        while (n < this.beans.size()) {
            Object e = this.beans.elementAt(n);
            if (e != null) {
                this.addEventSource(e);
            }
            ++n;
        }
    }

    void removeEventSource(Object object) {
        this.em.removeEncapsulatedEventListener(object, this.em, this.em.getSourceEventListenerInterfaces(object));
        this.beans.removeElement(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new IOException("EventMonitor isn't serializable");
    }
}

