/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import sunw.demo.classfile.ClassFile;
import sunw.demo.classfile.ConstantPoolEntry;
import sunw.demo.classfile.UTF8Constant;

class NameAndTypeConstant
extends ConstantPoolEntry {
    private UTF8Constant name;
    private UTF8Constant desc;

    NameAndTypeConstant(String string, String string2, ClassFile classFile) {
        super((byte)12, classFile);
        this.name = new UTF8Constant(string, classFile);
        this.desc = new UTF8Constant(string2, classFile);
        this.addToConstantPool();
    }

    public boolean equals(Object object) {
        if (object instanceof NameAndTypeConstant) {
            NameAndTypeConstant nameAndTypeConstant = (NameAndTypeConstant)object;
            return this.name.equals(nameAndTypeConstant.name) && this.desc.equals(nameAndTypeConstant.desc);
        }
        return false;
    }

    String getDescriptor() {
        return this.desc.getString();
    }

    String getName() {
        return this.name.getString();
    }

    public int hashCode() {
        return this.name.hashCode() + this.desc.hashCode();
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        if (ConstantPoolEntry.debug()) {
            System.err.println(String.valueOf(this.getConstantPoolIndex()) + " NAME: " + this.name.getConstantPoolIndex() + " TYPE: " + this.desc.getConstantPoolIndex());
        }
        dataOutputStream.writeByte(this.getTag());
        dataOutputStream.writeShort(this.name.getConstantPoolIndex());
        dataOutputStream.writeShort(this.desc.getConstantPoolIndex());
    }
}

